/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class PassthruEnvironmentRepository
implements EnvironmentRepository {
    private static final String DEFAULT_LABEL = "master";
    private Set<String> standardSources = new HashSet<String>(Arrays.asList("vcap", "systemProperties", "systemEnvironment", "jndiProperties", "servletConfigInitParams", "servletContextInitParams"));
    private ConfigurableEnvironment environment;

    public PassthruEnvironmentRepository(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public String getDefaultLabel() {
        return DEFAULT_LABEL;
    }

    @Override
    public Environment findOne(String application, String env, String label) {
        Environment result = new Environment(application, StringUtils.commaDelimitedListToStringArray((String)env), label, null, null);
        for (PropertySource source : this.environment.getPropertySources()) {
            String name = source.getName();
            if (this.standardSources.contains(name) || !(source instanceof MapPropertySource)) continue;
            result.add(new org.springframework.cloud.config.environment.PropertySource(name, this.getMap(source)));
        }
        return result;
    }

    private Map<?, ?> getMap(PropertySource<?> source) {
        LinkedHashMap map = new LinkedHashMap();
        Map input = (Map)source.getSource();
        for (Object key : input.keySet()) {
            map.put(key, source.getProperty(key.toString()));
        }
        return map;
    }
}

