/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentNotFoundException;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.RepositoryException;
import org.springframework.cloud.config.server.support.EnvironmentPropertySource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;

@RestController
@RequestMapping(method={RequestMethod.GET}, path={"${spring.cloud.config.server.prefix:}"})
public class EnvironmentController {
    private EnvironmentRepository repository;
    private ObjectMapper objectMapper;
    private boolean stripDocument = true;
    private boolean acceptEmpty = true;

    public EnvironmentController(EnvironmentRepository repository) {
        this(repository, new ObjectMapper());
    }

    public EnvironmentController(EnvironmentRepository repository, ObjectMapper objectMapper) {
        this.repository = repository;
        this.objectMapper = objectMapper;
    }

    public void setStripDocumentFromYaml(boolean stripDocument) {
        this.stripDocument = stripDocument;
    }

    public void setAcceptEmpty(boolean acceptEmpty) {
        this.acceptEmpty = acceptEmpty;
    }

    @RequestMapping(value={"/{name}/{profiles:.*[^-].*}"})
    public Environment defaultLabel(@PathVariable String name, @PathVariable String profiles) {
        return this.labelled(name, profiles, null);
    }

    @RequestMapping(value={"/{name}/{profiles}/{label:.*}"})
    public Environment labelled(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) {
        if (name != null && name.contains("(_)")) {
            name = name.replace("(_)", "/");
        }
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        Environment environment = this.repository.findOne(name, profiles, label);
        if (!this.acceptEmpty && (environment == null || environment.getPropertySources().isEmpty())) {
            throw new EnvironmentNotFoundException("Profile Not found");
        }
        return environment;
    }

    @RequestMapping(value={"/{name}-{profiles}.properties"})
    public ResponseEntity<String> properties(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws IOException {
        return this.labelledProperties(name, profiles, null, resolvePlaceholders);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.properties"})
    public ResponseEntity<String> labelledProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws IOException {
        this.validateProfiles(profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> properties = this.convertToProperties(environment);
        String propertiesString = this.getPropertiesString(properties);
        if (resolvePlaceholders) {
            propertiesString = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), propertiesString);
        }
        return this.getSuccess(propertiesString);
    }

    @RequestMapping(value={"{name}-{profiles}.json"})
    public ResponseEntity<String> jsonProperties(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        return this.labelledJsonProperties(name, profiles, null, resolvePlaceholders);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.json"})
    public ResponseEntity<String> labelledJsonProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        this.validateProfiles(profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> properties = this.convertToMap(environment);
        String json = this.objectMapper.writeValueAsString(properties);
        if (resolvePlaceholders) {
            json = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), json);
        }
        return this.getSuccess(json, MediaType.APPLICATION_JSON);
    }

    private String getPropertiesString(Map<String, Object> properties) {
        StringBuilder output = new StringBuilder();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (output.length() > 0) {
                output.append("\n");
            }
            String line = entry.getKey() + ": " + entry.getValue();
            output.append(line);
        }
        return output.toString();
    }

    @RequestMapping(value={"/{name}-{profiles}.yml", "/{name}-{profiles}.yaml"})
    public ResponseEntity<String> yaml(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        return this.labelledYaml(name, profiles, null, resolvePlaceholders);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.yml", "/{label}/{name}-{profiles}.yaml"})
    public ResponseEntity<String> labelledYaml(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        this.validateProfiles(profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> result = this.convertToMap(environment);
        if (this.stripDocument && result.size() == 1 && result.keySet().iterator().next().equals("document")) {
            Object value = result.get("document");
            if (value instanceof Collection) {
                return this.getSuccess(new Yaml().dumpAs(value, Tag.SEQ, DumperOptions.FlowStyle.BLOCK));
            }
            return this.getSuccess(new Yaml().dumpAs(value, Tag.STR, DumperOptions.FlowStyle.BLOCK));
        }
        String yaml = new Yaml().dumpAsMap(result);
        if (resolvePlaceholders) {
            yaml = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), yaml);
        }
        return this.getSuccess(yaml);
    }

    private Map<String, Object> convertToMap(Environment input) {
        Map<String, Object> properties = this.convertToProperties(input);
        LinkedHashMap<String, Object> rootMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            PropertyNavigator nav = new PropertyNavigator(key);
            nav.setMapValue(rootMap, value);
        }
        return rootMap;
    }

    @ExceptionHandler(value={RepositoryException.class})
    public void noSuchLabel(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.NOT_FOUND.value());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public void illegalArgument(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value());
    }

    private void validateProfiles(String profiles) {
        if (profiles.contains("-")) {
            throw new IllegalArgumentException("Properties output not supported for name or profiles containing hyphens");
        }
    }

    private HttpHeaders getHttpHeaders(MediaType mediaType) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(mediaType);
        return httpHeaders;
    }

    private ResponseEntity<String> getSuccess(String body) {
        return new ResponseEntity((Object)body, (MultiValueMap)this.getHttpHeaders(MediaType.TEXT_PLAIN), HttpStatus.OK);
    }

    private ResponseEntity<String> getSuccess(String body, MediaType mediaType) {
        return new ResponseEntity((Object)body, (MultiValueMap)this.getHttpHeaders(mediaType), HttpStatus.OK);
    }

    private Map<String, Object> convertToProperties(Environment profiles) {
        LinkedHashMap map = new LinkedHashMap();
        ArrayList sources = new ArrayList(profiles.getPropertySources());
        Collections.reverse(sources);
        TreeMap<String, Object> combinedMap = new TreeMap<String, Object>();
        for (PropertySource propertySource : sources) {
            Map value = propertySource.getSource();
            for (String key : value.keySet()) {
                if (!key.contains("[")) {
                    combinedMap.put(key, value.get(key));
                    continue;
                }
                key = key.substring(0, key.indexOf("["));
                TreeMap filtered = new TreeMap();
                for (String index : value.keySet()) {
                    if (!index.startsWith(key + "[")) continue;
                    filtered.put(index, value.get(index));
                }
                map.put(key, filtered);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            combinedMap.putAll((Map)entry.getValue());
        }
        this.postProcessProperties(combinedMap);
        return combinedMap;
    }

    private void postProcessProperties(Map<String, Object> propertiesMap) {
        Iterator<String> iter = propertiesMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equals("spring.profiles")) continue;
            iter.remove();
        }
    }

    private static class PropertyNavigator {
        private final String propertyKey;
        private int currentPos;
        private NodeType valueType;

        private PropertyNavigator(String propertyKey) {
            this.propertyKey = propertyKey;
            this.currentPos = -1;
            this.valueType = NodeType.MAP;
        }

        private void setMapValue(Map<String, Object> map, Object value) {
            String key = this.getKey();
            if (NodeType.MAP.equals((Object)this.valueType)) {
                LinkedHashMap<String, Object> nestedMap = (LinkedHashMap<String, Object>)map.get(key);
                if (nestedMap == null) {
                    nestedMap = new LinkedHashMap<String, Object>();
                    map.put(key, nestedMap);
                }
                this.setMapValue(nestedMap, value);
            } else if (NodeType.ARRAY.equals((Object)this.valueType)) {
                ArrayList<Object> list = (ArrayList<Object>)map.get(key);
                if (list == null) {
                    list = new ArrayList<Object>();
                    map.put(key, list);
                }
                this.setListValue(list, value);
            } else {
                map.put(key, value);
            }
        }

        private void setListValue(List<Object> list, Object value) {
            int index = this.getIndex();
            while (list.size() <= index) {
                list.add(null);
            }
            if (NodeType.MAP.equals((Object)this.valueType)) {
                LinkedHashMap<String, Object> map = (LinkedHashMap<String, Object>)list.get(index);
                if (map == null) {
                    map = new LinkedHashMap<String, Object>();
                    list.set(index, map);
                }
                this.setMapValue(map, value);
            } else if (NodeType.ARRAY.equals((Object)this.valueType)) {
                ArrayList<Object> nestedList = (ArrayList<Object>)list.get(index);
                if (nestedList == null) {
                    nestedList = new ArrayList<Object>();
                    list.set(index, nestedList);
                }
                this.setListValue(nestedList, value);
            } else {
                list.set(index, value);
            }
        }

        private int getIndex() {
            int start;
            for (int i = start = this.currentPos + 1; i < this.propertyKey.length(); ++i) {
                char c = this.propertyKey.charAt(i);
                if (c == ']') {
                    this.currentPos = i;
                    break;
                }
                if (Character.isDigit(c)) continue;
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            if (this.currentPos < start || this.currentPos == start) {
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            int index = Integer.parseInt(this.propertyKey.substring(start, this.currentPos));
            ++this.currentPos;
            if (this.currentPos == this.propertyKey.length()) {
                this.valueType = NodeType.LEAF;
            } else {
                switch (this.propertyKey.charAt(this.currentPos)) {
                    case '.': {
                        this.valueType = NodeType.MAP;
                        break;
                    }
                    case '[': {
                        this.valueType = NodeType.ARRAY;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
                    }
                }
            }
            return index;
        }

        private String getKey() {
            int start;
            for (int i = start = this.currentPos + 1; i < this.propertyKey.length(); ++i) {
                char currentChar = this.propertyKey.charAt(i);
                if (currentChar == '.') {
                    this.valueType = NodeType.MAP;
                    this.currentPos = i;
                    break;
                }
                if (currentChar != '[') continue;
                this.valueType = NodeType.ARRAY;
                this.currentPos = i;
                break;
            }
            if (this.currentPos < start) {
                this.currentPos = this.propertyKey.length();
                this.valueType = NodeType.LEAF;
            } else if (this.currentPos == start) {
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            return this.propertyKey.substring(start, this.currentPos);
        }

        private static enum NodeType {
            LEAF,
            MAP,
            ARRAY;

        }
    }
}

