/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jmx.export.MBeanExporter;

@Configuration
@ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
class DataSourceJmxConfiguration {
    private static final Log logger = LogFactory.getLog(DataSourceJmxConfiguration.class);

    DataSourceJmxConfiguration() {
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.datasource", name={"jmx-enabled"})
    @ConditionalOnClass(name={"org.apache.tomcat.jdbc.pool.DataSourceProxy"})
    @ConditionalOnSingleCandidate(value=DataSource.class)
    static class TomcatDataSourceJmxConfiguration {
        TomcatDataSourceJmxConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"dataSourceMBean"})
        public Object dataSourceMBean(DataSource dataSource) {
            DataSourceProxy dataSourceProxy = (DataSourceProxy)DataSourceUnwrapper.unwrap((DataSource)dataSource, DataSourceProxy.class);
            if (dataSourceProxy != null) {
                try {
                    return dataSourceProxy.createPool().getJmxPool();
                }
                catch (SQLException ex) {
                    logger.warn((Object)"Cannot expose DataSource to JMX (could not connect)");
                }
            }
            return null;
        }
    }

    @Configuration
    @ConditionalOnClass(value={HikariDataSource.class})
    @ConditionalOnSingleCandidate(value=DataSource.class)
    static class Hikari {
        private final DataSource dataSource;
        private final ObjectProvider<MBeanExporter> mBeanExporter;

        Hikari(DataSource dataSource, ObjectProvider<MBeanExporter> mBeanExporter) {
            this.dataSource = dataSource;
            this.mBeanExporter = mBeanExporter;
        }

        @PostConstruct
        public void validateMBeans() {
            HikariDataSource hikariDataSource = (HikariDataSource)DataSourceUnwrapper.unwrap((DataSource)this.dataSource, HikariDataSource.class);
            if (hikariDataSource != null && hikariDataSource.isRegisterMbeans()) {
                this.mBeanExporter.ifUnique(exporter -> exporter.addExcludedBean("dataSource"));
            }
        }
    }
}

