/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.aggregator;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apiguardian.api.API;
import org.junit.jupiter.params.aggregator.AggregateWith;
import org.junit.jupiter.params.aggregator.ArgumentsAccessor;
import org.junit.platform.commons.util.AnnotationUtils;

@API(status=API.Status.INTERNAL, since="5.2")
public class AggregationUtils {
    private AggregationUtils() {
    }

    public static boolean hasPotentiallyValidSignature(Method method) {
        Parameter[] parameters = method.getParameters();
        int indexOfPreviousAggregator = -1;
        for (int i = 0; i < parameters.length; ++i) {
            if (!AggregationUtils.isAggregator(parameters[i])) continue;
            if (indexOfPreviousAggregator != -1 && i != indexOfPreviousAggregator + 1) {
                return false;
            }
            indexOfPreviousAggregator = i;
        }
        return true;
    }

    public static boolean isAggregator(Parameter parameter) {
        return ArgumentsAccessor.class.isAssignableFrom(parameter.getType()) || AnnotationUtils.isAnnotated((AnnotatedElement)parameter, AggregateWith.class);
    }

    public static boolean hasAggregator(Method method) {
        return AggregationUtils.indexOfFirstAggregator(method) != -1;
    }

    public static int indexOfFirstAggregator(Method method) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!AggregationUtils.isAggregator(parameters[i])) continue;
            return i;
        }
        return -1;
    }
}

