/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.CreateTableAsStep;
import org.jooq.CreateTableColumnStep;
import org.jooq.CreateTableWithDataStep;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.ConstraintImpl;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Tools;

final class CreateTableImpl<R extends Record>
extends AbstractQuery
implements CreateTableAsStep<R>,
CreateTableWithDataStep,
CreateTableColumnStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final EnumSet<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = EnumSet.of(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final EnumSet<SQLDialect> NO_SUPPORT_WITH_DATA = EnumSet.of(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final EnumSet<SQLDialect> EMULATE_INDEXES_IN_BLOCK = EnumSet.of(SQLDialect.POSTGRES);
    private static final EnumSet<SQLDialect> EMULATE_ENUM_TYPES_AS_CHECK = EnumSet.of(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.SQLITE);
    private static final EnumSet<SQLDialect> REQUIRES_WITH_DATA = EnumSet.of(SQLDialect.HSQLDB);
    private static final EnumSet<SQLDialect> WRAP_SELECT_IN_PARENS = EnumSet.of(SQLDialect.HSQLDB);
    private static final EnumSet<SQLDialect> SUPPORT_TEMPORARY = EnumSet.of(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES);
    private static final EnumSet<SQLDialect> EMULATE_COMMENT_IN_BLOCK = EnumSet.of(SQLDialect.POSTGRES);
    private final Table<?> table;
    private Select<?> select;
    private Boolean withData;
    private final List<Field<?>> columnFields;
    private final List<DataType<?>> columnTypes;
    private final List<Constraint> constraints;
    private final List<Index> indexes;
    private final boolean temporary;
    private final boolean ifNotExists;
    private OnCommit onCommit;
    private Comment comment;
    private SQL storage;

    CreateTableImpl(Configuration configuration, Table<?> table, boolean temporary, boolean ifNotExists) {
        super(configuration);
        this.table = table;
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.columnFields = new ArrayList();
        this.columnTypes = new ArrayList();
        this.constraints = new ArrayList<Constraint>();
        this.indexes = new ArrayList<Index>();
    }

    @Override
    public final CreateTableImpl<R> as(Select<? extends R> s) {
        this.select = s;
        return this;
    }

    @Override
    public final CreateTableImpl<R> withData() {
        this.withData = true;
        return this;
    }

    @Override
    public final CreateTableImpl<R> withNoData() {
        this.withData = false;
        return this;
    }

    @Override
    public final CreateTableImpl<R> column(Field<?> field) {
        return this.column((Field)field, (DataType)field.getDataType());
    }

    @Override
    public final CreateTableImpl<R> columns(Field<?> ... fields) {
        return this.columns(Arrays.asList(fields));
    }

    @Override
    public final CreateTableImpl<R> columns(Collection<? extends Field<?>> fields) {
        for (Field<?> field : fields) {
            this.column((Field)field);
        }
        return this;
    }

    @Override
    public final <T> CreateTableImpl<R> column(Field<T> field, DataType<T> type) {
        this.columnFields.add(field);
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableImpl<R> column(Name field, DataType<?> type) {
        this.columnFields.add(DSL.field(field, type));
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableImpl<R> column(String field, DataType<?> type) {
        return this.column(DSL.name(field), (DataType)type);
    }

    @Override
    public final CreateTableImpl<R> constraint(Constraint c) {
        return this.constraints(Arrays.asList(c));
    }

    @Override
    public final CreateTableImpl<R> constraints(Constraint ... c) {
        return this.constraints(Arrays.asList(c));
    }

    @Override
    public final CreateTableImpl<R> constraints(Collection<? extends Constraint> c) {
        this.constraints.addAll(c);
        return this;
    }

    @Override
    public final CreateTableImpl<R> index(Index i) {
        return this.indexes(Arrays.asList(i));
    }

    @Override
    public final CreateTableImpl<R> indexes(Index ... i) {
        return this.indexes(Arrays.asList(i));
    }

    @Override
    public final CreateTableImpl<R> indexes(Collection<? extends Index> i) {
        this.indexes.addAll(i);
        return this;
    }

    @Override
    public final CreateTableImpl<R> onCommitDeleteRows() {
        this.onCommit = OnCommit.DELETE_ROWS;
        return this;
    }

    @Override
    public final CreateTableImpl<R> onCommitPreserveRows() {
        this.onCommit = OnCommit.PRESERVE_ROWS;
        return this;
    }

    @Override
    public final CreateTableImpl<R> onCommitDrop() {
        this.onCommit = OnCommit.DROP;
        return this;
    }

    @Override
    public final CreateTableImpl<R> comment(String c) {
        return this.comment(DSL.comment(c));
    }

    @Override
    public final CreateTableImpl<R> comment(Comment c) {
        this.comment = c;
        return this;
    }

    @Override
    public final CreateTableImpl<R> storage(SQL sql) {
        this.storage = sql;
        return this;
    }

    @Override
    public final CreateTableImpl<R> storage(String sql) {
        return this.storage(DSL.sql(sql));
    }

    @Override
    public final CreateTableImpl<R> storage(String sql, Object ... bindings) {
        return this.storage(DSL.sql(sql, bindings));
    }

    @Override
    public final CreateTableImpl<R> storage(String sql, QueryPart ... parts) {
        return this.storage(DSL.sql(sql, parts));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_TABLE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_TABLE);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean i;
        boolean c = this.comment != null && EMULATE_COMMENT_IN_BLOCK.contains((Object)ctx.family());
        boolean bl = i = !this.indexes.isEmpty() && EMULATE_INDEXES_IN_BLOCK.contains((Object)ctx.family());
        if (c || i) {
            Tools.begin(ctx);
            this.accept1(ctx);
            ctx.sql(';');
            if (c) {
                ctx.formatSeparator();
                ctx.visit(DSL.commentOnTable(this.table).is(this.comment));
                ctx.sql(';');
            }
            if (i) {
                for (Index index : this.indexes) {
                    ctx.formatSeparator();
                    if ("".equals(index.getName())) {
                        ctx.visit(DSL.createIndex().on(index.getTable(), index.getFields()));
                    } else {
                        ctx.visit(DSL.createIndex(index.getUnqualifiedName()).on(index.getTable(), index.getFields()));
                    }
                    ctx.sql(';');
                }
            }
            Tools.end(ctx);
            return;
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE);
        if (this.select != null) {
            this.acceptCreateTableAsSelect(ctx);
        } else {
            DataType<?> type;
            int i;
            this.toSQLCreateTableName(ctx);
            ctx.sql('(').start(Clause.CREATE_TABLE_COLUMNS).formatIndentStart().formatNewLine();
            Field<?> identity = null;
            boolean qualify = ctx.qualify();
            ctx.qualify(false);
            for (i = 0; i < this.columnFields.size(); ++i) {
                type = this.columnTypes.get(i);
                if (identity == null && type.identity()) {
                    identity = this.columnFields.get(i);
                }
                ctx.visit(this.columnFields.get(i)).sql(' ');
                Tools.toSQLDDLTypeDeclarationForAddition(ctx, type);
                if (i >= this.columnFields.size() - 1) continue;
                ctx.sql(',').formatSeparator();
            }
            ctx.qualify(qualify);
            ctx.end(Clause.CREATE_TABLE_COLUMNS).start(Clause.CREATE_TABLE_CONSTRAINTS);
            if (!this.constraints.isEmpty()) {
                for (Constraint constraint : this.constraints) {
                    if (ctx.family() == SQLDialect.SQLITE && this.matchingPrimaryKey(constraint, identity)) continue;
                    ctx.sql(',').formatSeparator().visit(constraint);
                }
            }
            if (EMULATE_ENUM_TYPES_AS_CHECK.contains((Object)ctx.family())) {
                for (i = 0; i < this.columnFields.size(); ++i) {
                    type = this.columnTypes.get(i);
                    if (!EnumType.class.isAssignableFrom(type.getType())) continue;
                    Field<?> field = this.columnFields.get(i);
                    ctx.sql(',').formatSeparator().visit(DSL.constraint(this.table.getName() + "_" + field.getName() + "_chk").check(field.in(Tools.enumLiterals(type.getType()))));
                }
            }
            ctx.end(Clause.CREATE_TABLE_CONSTRAINTS);
            if (!this.indexes.isEmpty() && !EMULATE_INDEXES_IN_BLOCK.contains((Object)ctx.family())) {
                ctx.qualify(false);
                for (Index index : this.indexes) {
                    ctx.sql(',').formatSeparator().visit(Keywords.K_INDEX);
                    if (!"".equals(index.getName())) {
                        ctx.sql(' ').visit(index.getUnqualifiedName());
                    }
                    ctx.sql(" (").visit(new SortFieldList(index.getFields())).sql(')');
                }
                ctx.qualify(qualify);
            }
            ctx.formatIndentEnd().formatNewLine().sql(')');
            this.toSQLOnCommit(ctx);
        }
        if (this.comment != null && !EMULATE_COMMENT_IN_BLOCK.contains((Object)ctx.family())) {
            ctx.formatSeparator().visit(Keywords.K_COMMENT).sql(' ').visit(this.comment);
        }
        if (this.storage != null && ctx.configuration().data("org.jooq.meta.extensions.ddl.ignore-storage-clauses") == null) {
            ctx.formatSeparator().visit(this.storage);
        }
        ctx.end(Clause.CREATE_TABLE);
    }

    private final boolean matchingPrimaryKey(Constraint constraint, Field<?> identity) {
        if (constraint instanceof ConstraintImpl) {
            return ((ConstraintImpl)constraint).matchingPrimaryKey(identity);
        }
        return false;
    }

    private final void acceptCreateTableAsSelect(Context<?> ctx) {
        this.toSQLCreateTableName(ctx);
        this.toSQLOnCommit(ctx);
        ctx.formatSeparator().visit(Keywords.K_AS);
        if (WRAP_SELECT_IN_PARENS.contains((Object)ctx.family())) {
            ctx.sql(" (").formatIndentStart().formatNewLine();
        } else {
            ctx.formatSeparator();
        }
        if (Boolean.FALSE.equals(this.withData) && NO_SUPPORT_WITH_DATA.contains((Object)ctx.family())) {
            ctx.data((Object)Tools.DataKey.DATA_SELECT_NO_DATA, true);
        }
        ctx.start(Clause.CREATE_TABLE_AS).visit(this.select).end(Clause.CREATE_TABLE_AS);
        if (Boolean.FALSE.equals(this.withData) && NO_SUPPORT_WITH_DATA.contains((Object)ctx.family())) {
            ctx.data().remove((Object)Tools.DataKey.DATA_SELECT_NO_DATA);
        }
        if (WRAP_SELECT_IN_PARENS.contains((Object)ctx.family())) {
            ctx.formatIndentEnd().formatNewLine().sql(')');
        }
        if (Boolean.FALSE.equals(this.withData) && !NO_SUPPORT_WITH_DATA.contains((Object)ctx.family())) {
            ctx.sql(' ').visit(Keywords.K_WITH_NO_DATA);
        } else if (Boolean.TRUE.equals(this.withData) && !NO_SUPPORT_WITH_DATA.contains((Object)ctx.family())) {
            ctx.sql(' ').visit(Keywords.K_WITH_DATA);
        } else if (REQUIRES_WITH_DATA.contains((Object)ctx.family())) {
            ctx.sql(' ').visit(Keywords.K_WITH_DATA);
        }
    }

    private final void toSQLCreateTableName(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE_NAME).visit(Keywords.K_CREATE).sql(' ');
        if (this.temporary) {
            if (SUPPORT_TEMPORARY.contains((Object)ctx.family())) {
                ctx.visit(Keywords.K_TEMPORARY).sql(' ');
            } else {
                ctx.visit(Keywords.K_GLOBAL_TEMPORARY).sql(' ');
            }
        }
        ctx.visit(Keywords.K_TABLE).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.table).end(Clause.CREATE_TABLE_NAME);
    }

    private final void toSQLOnCommit(Context<?> ctx) {
        if (this.temporary && this.onCommit != null) {
            switch (this.onCommit) {
                case DELETE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DELETE_ROWS);
                    break;
                }
                case PRESERVE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_PRESERVE_ROWS);
                    break;
                }
                case DROP: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DROP);
                }
            }
        }
    }

    private final void acceptSelectInto(Context<?> ctx) {
        if (Boolean.FALSE.equals(this.withData)) {
            ctx.data((Object)Tools.DataKey.DATA_SELECT_NO_DATA, true);
        }
        ctx.data((Object)Tools.DataKey.DATA_SELECT_INTO_TABLE, this.table);
        ctx.visit(this.select);
        ctx.data().remove((Object)Tools.DataKey.DATA_SELECT_INTO_TABLE);
        if (Boolean.FALSE.equals(this.withData)) {
            ctx.data().remove((Object)Tools.DataKey.DATA_SELECT_NO_DATA);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private static enum OnCommit {
        DELETE_ROWS,
        PRESERVE_ROWS,
        DROP;

    }
}

