/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.languages.java.jpms.AsmModuleInfoParser;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.MainClassModuleNameExtractor;
import org.codehaus.plexus.languages.java.jpms.ManifestModuleNameExtractor;
import org.codehaus.plexus.languages.java.jpms.ModuleInfoParser;
import org.codehaus.plexus.languages.java.jpms.QDoxModuleInfoParser;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;

@Singleton
@Component(role=LocationManager.class)
public class LocationManager {
    private ModuleInfoParser asmParser;
    private QDoxModuleInfoParser qdoxParser;

    public LocationManager() {
        this.asmParser = new AsmModuleInfoParser();
        this.qdoxParser = new QDoxModuleInfoParser();
    }

    LocationManager(ModuleInfoParser asmParser, QDoxModuleInfoParser qdoxParser) {
        this.asmParser = asmParser;
        this.qdoxParser = qdoxParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> ResolvePathsResult<T> resolvePaths(ResolvePathsRequest<T> request) throws IOException {
        JavaModuleDescriptor mainModuleDescriptor;
        ResolvePathsResult result = request.createResult();
        LinkedHashMap<Object, JavaModuleDescriptor> pathElements = new LinkedHashMap<Object, JavaModuleDescriptor>(request.getPathElements().size());
        Path descriptorPath = request.getMainModuleDescriptor();
        if (descriptorPath != null) {
            if (descriptorPath.endsWith("module-info.java")) {
                mainModuleDescriptor = this.qdoxParser.fromSourcePath(descriptorPath);
            } else {
                if (!descriptorPath.endsWith("module-info.class")) throw new IOException("Invalid path to module descriptor: " + descriptorPath);
                mainModuleDescriptor = this.asmParser.getModuleDescriptor(descriptorPath.getParent());
            }
        } else {
            mainModuleDescriptor = null;
        }
        HashMap<String, JavaModuleDescriptor> availableNamedModules = new HashMap<String, JavaModuleDescriptor>();
        HashMap<String, ResolvePathsResult.ModuleNameSource> moduleNameSources = new HashMap<String, ResolvePathsResult.ModuleNameSource>();
        result.setMainModuleDescriptor(mainModuleDescriptor);
        HashMap<T, Path> filenameAutoModules = new HashMap<T, Path>();
        ManifestModuleNameExtractor manifestModuleNameExtractor = new ManifestModuleNameExtractor();
        for (T t : request.getPathElements()) {
            Path path = request.toPath(t);
            JavaModuleDescriptor moduleDescriptor = null;
            ResolvePathsResult.ModuleNameSource source = null;
            if (Files.isRegularFile(path, new LinkOption[0]) || Files.exists(path.resolve("module-info.class"), new LinkOption[0])) {
                moduleDescriptor = this.asmParser.getModuleDescriptor(path);
            }
            if (moduleDescriptor != null) {
                source = ResolvePathsResult.ModuleNameSource.MODULEDESCRIPTOR;
            } else {
                String moduleName = manifestModuleNameExtractor.extract(path);
                if (moduleName != null) {
                    source = ResolvePathsResult.ModuleNameSource.MANIFEST;
                } else if (request.getJdkHome() != null) {
                    filenameAutoModules.put(t, path);
                } else {
                    moduleName = MainClassModuleNameExtractor.getModuleName(path);
                    if (moduleName != null) {
                        source = ResolvePathsResult.ModuleNameSource.FILENAME;
                    }
                }
                if (moduleName != null) {
                    moduleDescriptor = JavaModuleDescriptor.newAutomaticModule(moduleName).build();
                }
            }
            if (moduleDescriptor != null) {
                moduleNameSources.put(moduleDescriptor.name(), source);
                availableNamedModules.put(moduleDescriptor.name(), moduleDescriptor);
            }
            pathElements.put(t, moduleDescriptor);
        }
        result.setPathElements(pathElements);
        if (!filenameAutoModules.isEmpty()) {
            MainClassModuleNameExtractor extractor = new MainClassModuleNameExtractor(request.getJdkHome());
            Map automodules = extractor.extract(filenameAutoModules);
            for (Map.Entry entry : automodules.entrySet()) {
                String moduleName = entry.getValue();
                if (moduleName == null) continue;
                JavaModuleDescriptor moduleDescriptor = JavaModuleDescriptor.newAutomaticModule(moduleName).build();
                moduleNameSources.put(moduleDescriptor.name(), ResolvePathsResult.ModuleNameSource.FILENAME);
                availableNamedModules.put(moduleDescriptor.name(), moduleDescriptor);
                pathElements.put(entry.getKey(), moduleDescriptor);
            }
        }
        if (mainModuleDescriptor == null) return result;
        HashSet<String> requiredNamedModules = new HashSet<String>();
        requiredNamedModules.add(mainModuleDescriptor.name());
        this.select(mainModuleDescriptor, Collections.unmodifiableMap(availableNamedModules), requiredNamedModules);
        for (Map.Entry entry : pathElements.entrySet()) {
            if (entry.getValue() != null && requiredNamedModules.contains(((JavaModuleDescriptor)entry.getValue()).name())) {
                result.getModulepathElements().put((T)entry.getKey(), (ResolvePathsResult.ModuleNameSource)((Object)moduleNameSources.get(((JavaModuleDescriptor)entry.getValue()).name())));
                continue;
            }
            result.getClasspathElements().add(entry.getKey());
        }
        return result;
    }

    private void select(JavaModuleDescriptor module, Map<String, JavaModuleDescriptor> availableModules, Set<String> namedModules) {
        for (JavaModuleDescriptor.JavaRequires requires : module.requires()) {
            String requiresName = requires.name();
            JavaModuleDescriptor requiredModule = availableModules.get(requiresName);
            if (requiredModule == null || !namedModules.add(requiresName)) continue;
            this.select(requiredModule, availableModules, namedModules);
        }
    }
}

