/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.MinimalMavenBuildVersionFinder;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.ordering.MavenVersionComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

@Mojo(name="display-plugin-updates", threadSafe=true)
public class DisplayPluginUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int WARN_PAD_SIZE = 65;
    private static final int INFO_PAD_SIZE = 68;
    private static final String FROM_SUPER_POM = "(from super-pom) ";
    public static final String DEFAULT_MVN_VERSION = "3.2.5";
    private LifecycleExecutor lifecycleExecutor;
    private ModelInterpolator modelInterpolator;
    private final RuntimeInformation runtimeInformation;
    protected final ProjectBuilder projectBuilder;

    @Inject
    public DisplayPluginUpdatesMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, ProjectBuilder projectBuilder, Map<String, Wagon> wagonMap, LifecycleExecutor lifecycleExecutor, ModelInterpolator modelInterpolator, RuntimeInformation runtimeInformation, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
        this.projectBuilder = projectBuilder;
        this.lifecycleExecutor = lifecycleExecutor;
        this.modelInterpolator = modelInterpolator;
        this.runtimeInformation = runtimeInformation;
    }

    private Map<String, String> getSuperPomPluginManagement() throws MojoExecutionException {
        Map result = this.lifecycleExecutor.getPluginsBoundByDefaultToAllLifecycles(this.getProject().getPackaging()).stream().collect(LinkedHashMap::new, (m, p) -> m.put(p.getKey(), p.getVersion()), Map::putAll);
        URL superPom = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/model/pom-4.0.0.xml");
        if (superPom != null) {
            try (XmlStreamReader reader = ReaderFactory.newXmlReader((URL)superPom);){
                StringBuilder buf = new StringBuilder(IOUtil.toString((Reader)reader));
                ModifiedPomXMLEventReader pom = this.newModifiedPomXER(buf, superPom.toString());
                Pattern pathRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
                Stack<StackState> pathStack = new Stack<StackState>();
                StackState curState = null;
                while (pom.hasNext()) {
                    XMLEvent event = pom.nextEvent();
                    if (event.isStartDocument()) {
                        curState = new StackState("");
                        pathStack.clear();
                        continue;
                    }
                    if (event.isStartElement()) {
                        String elementName = event.asStartElement().getName().getLocalPart();
                        if (curState != null && pathRegex.matcher(curState.path).matches()) {
                            if ("groupId".equals(elementName)) {
                                curState.groupId = pom.getElementText().trim();
                                continue;
                            }
                            if ("artifactId".equals(elementName)) {
                                curState.artifactId = pom.getElementText().trim();
                                continue;
                            }
                            if ("version".equals(elementName)) {
                                curState.version = pom.getElementText().trim();
                                continue;
                            }
                        }
                        pathStack.push(curState);
                        curState = new StackState(curState.path + "/" + elementName);
                        continue;
                    }
                    if (!event.isEndElement()) continue;
                    if (curState != null && pathRegex.matcher(curState.path).matches() && curState.artifactId != null) {
                        Plugin plugin = new Plugin();
                        plugin.setArtifactId(curState.artifactId);
                        plugin.setGroupId(curState.groupId == null ? "org.apache.maven.plugins" : curState.groupId);
                        plugin.setVersion(curState.version);
                        if (!result.containsKey(plugin.getKey())) {
                            result.put(plugin.getKey(), plugin.getVersion());
                        }
                    }
                    curState = (StackState)pathStack.pop();
                }
            }
            catch (IOException | XMLStreamException exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Map<String, String> getPluginManagement(Model model) {
        HashMap<String, String> pluginManagement = new HashMap<String, String>();
        try {
            for (Plugin plugin : model.getBuild().getPluginManagement().getPlugins()) {
                String coord = plugin.getKey();
                String version = plugin.getVersion();
                if (version == null) continue;
                pluginManagement.put(coord, version);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (Plugin plugin : profile.getBuild().getPluginManagement().getPlugins()) {
                        String coord = plugin.getKey();
                        String version = plugin.getVersion();
                        if (version == null) continue;
                        pluginManagement.put(coord, version);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return pluginManagement;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean noMavenMinVersion;
        Set<String> pluginsWithVersionsSpecified;
        this.logInit();
        try {
            MavenProject project1 = this.getProject();
            pluginsWithVersionsSpecified = this.findPluginsWithVersionsSpecified(PomHelper.readXmlFile((File)project1.getFile()), this.getSafeProjectPathInfo(project1));
        }
        catch (IOException | XMLStreamException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        Map<String, String> superPomPluginManagement = this.getSuperPomPluginManagement();
        this.getLog().debug((CharSequence)("superPom plugins = " + superPomPluginManagement));
        List<MavenProject> parents = this.getParentProjects(this.getProject());
        Map<String, String> parentPlugins = this.getParentsPlugins(parents);
        HashMap<String, String> parentBuildPlugins = new HashMap<String, String>();
        HashMap<String, String> parentReportPlugins = new HashMap<String, String>();
        Set<Plugin> plugins = this.getProjectPlugins(superPomPluginManagement, parentPlugins, parentBuildPlugins, parentReportPlugins, pluginsWithVersionsSpecified);
        ArrayList<String> pluginUpdates = new ArrayList<String>();
        ArrayList<String> pluginLockdowns = new ArrayList<String>();
        DefaultArtifactVersion curMavenVersion = new DefaultArtifactVersion(this.runtimeInformation.getMavenVersion());
        ArtifactVersion specMavenVersion = MinimalMavenBuildVersionFinder.find(this.getProject(), DEFAULT_MVN_VERSION, this.getLog());
        ArtifactVersion minMavenVersion = null;
        boolean superPomDrivingMinVersion = false;
        TreeMap<ArtifactVersion, Map> mavenUpgrades = new TreeMap<ArtifactVersion, Map>((Comparator<ArtifactVersion>)new MavenVersionComparator());
        for (Plugin plugin : plugins) {
            String newVersion;
            Object artifactVersion;
            String effectiveVersion;
            boolean versionSpecifiedInCurrentPom;
            String coords;
            String version;
            String artifactId;
            String groupId;
            block43: {
                groupId = plugin.getGroupId();
                artifactId = plugin.getArtifactId();
                version = plugin.getVersion();
                coords = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
                if (version == null) {
                    version = parentPlugins.get(coords);
                }
                if (!(versionSpecifiedInCurrentPom = pluginsWithVersionsSpecified.contains(coords)) && parentPlugins.containsKey(coords)) {
                    this.getLog().debug((CharSequence)("Skip " + coords + ", version " + version + " is defined in parent POM."));
                    continue;
                }
                this.getLog().debug((CharSequence)("Checking " + coords + " for updates newer than " + version));
                effectiveVersion = version;
                Artifact artifactRange = this.getHelper().createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), version);
                artifactVersion = null;
                try {
                    ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifactRange, true);
                    ArtifactVersion[] newerVersions = artifactVersions.getVersions(this.allowSnapshots);
                    ArtifactVersion minRequires = null;
                    for (int j = newerVersions.length - 1; j >= 0; --j) {
                        try {
                            String upgradePluginKey;
                            ArtifactVersion pluginRequires = this.getPrerequisitesMavenVersion(this.getPluginProject(groupId, artifactId, newerVersions[j].toString()));
                            if (artifactVersion == null && DisplayPluginUpdatesMojo.compare(specMavenVersion, pluginRequires) >= 0) {
                                artifactVersion = newerVersions[j];
                            }
                            if (effectiveVersion == null && DisplayPluginUpdatesMojo.compare((ArtifactVersion)curMavenVersion, pluginRequires) >= 0) {
                                effectiveVersion = newerVersions[j].toString();
                            }
                            if (artifactVersion != null && effectiveVersion != null) break;
                            if (minRequires != null && DisplayPluginUpdatesMojo.compare(minRequires, pluginRequires) <= 0) continue;
                            Map upgradePlugins = mavenUpgrades.computeIfAbsent(pluginRequires, k -> new LinkedHashMap());
                            if (!upgradePlugins.containsKey(upgradePluginKey = this.compactKey(groupId, artifactId))) {
                                String newer = newerVersions[j].toString();
                                if (newer.equals(effectiveVersion)) {
                                    upgradePlugins.put(upgradePluginKey, DisplayPluginUpdatesMojo.pad(upgradePluginKey, 68 + this.getOutputLineWidthOffset(), newer));
                                } else {
                                    upgradePlugins.put(upgradePluginKey, DisplayPluginUpdatesMojo.pad(upgradePluginKey, 68 + this.getOutputLineWidthOffset(), effectiveVersion, " -> ", newer));
                                }
                            }
                            minRequires = pluginRequires;
                            continue;
                        }
                        catch (ArtifactResolutionException | ProjectBuildingException throwable) {
                            // empty catch block
                        }
                    }
                    if (effectiveVersion == null) break block43;
                    try {
                        ArtifactVersion requires = this.getPrerequisitesMavenVersion(this.getPluginProject(groupId, artifactId, effectiveVersion));
                        if (minMavenVersion == null || DisplayPluginUpdatesMojo.compare(minMavenVersion, requires) < 0) {
                            minMavenVersion = requires;
                        }
                    }
                    catch (ArtifactResolutionException | ProjectBuildingException throwable) {}
                }
                catch (VersionRetrievalException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
            if (version == null && versionSpecifiedInCurrentPom) {
                version = artifactVersion != null ? artifactVersion.toString() : null;
            }
            this.getLog().debug((CharSequence)("[" + coords + "].version=" + version));
            this.getLog().debug((CharSequence)("[" + coords + "].artifactVersion=" + artifactVersion));
            this.getLog().debug((CharSequence)("[" + coords + "].effectiveVersion=" + effectiveVersion));
            this.getLog().debug((CharSequence)("[" + coords + "].specified=" + versionSpecifiedInCurrentPom));
            if (version == null || !versionSpecifiedInCurrentPom) {
                version = superPomPluginManagement.get(coords);
                this.getLog().debug((CharSequence)("[" + coords + "].superPom.version=" + version));
                String string = artifactVersion != null ? artifactVersion.toString() : (version != null ? version : (newVersion = effectiveVersion != null ? effectiveVersion : "(unknown)"));
                if (version != null) {
                    superPomDrivingMinVersion = true;
                }
                pluginLockdowns.add(DisplayPluginUpdatesMojo.pad(this.compactKey(groupId, artifactId), 65 + this.getOutputLineWidthOffset(), superPomDrivingMinVersion ? FROM_SUPER_POM : "", newVersion));
            } else {
                newVersion = artifactVersion != null ? artifactVersion.toString() : null;
            }
            if (version == null || artifactVersion == null || newVersion == null || effectiveVersion == null || new DefaultArtifactVersion(effectiveVersion).compareTo((ArtifactVersion)new DefaultArtifactVersion(newVersion)) >= 0) continue;
            pluginUpdates.add(DisplayPluginUpdatesMojo.pad(this.compactKey(groupId, artifactId), 68 + this.getOutputLineWidthOffset(), effectiveVersion, " -> ", newVersion));
        }
        this.logLine(false, "");
        if (pluginUpdates.isEmpty()) {
            this.logLine(false, "All plugins with a version specified are using the latest versions.");
        } else {
            this.logLine(false, "The following plugin updates are available:");
            for (String update : new TreeSet(pluginUpdates)) {
                this.logLine(false, update);
            }
        }
        this.logLine(false, "");
        if (pluginLockdowns.isEmpty()) {
            this.logLine(false, "All plugins have a version specified.");
        } else {
            this.getLog().warn((CharSequence)"The following plugins do not have their version specified:");
            for (String lockdown : new TreeSet(pluginLockdowns)) {
                this.getLog().warn((CharSequence)lockdown);
            }
        }
        this.logLine(false, "");
        boolean bl = noMavenMinVersion = MinimalMavenBuildVersionFinder.find(this.getProject(), null, this.getLog()) == null;
        if (noMavenMinVersion) {
            this.getLog().warn((CharSequence)"Project does not define minimum Maven version required for build, default is: 3.2.5");
        } else {
            this.logLine(false, "Project requires minimum Maven version for build of: " + specMavenVersion);
        }
        this.logLine(false, "Plugins require minimum Maven version of: " + minMavenVersion);
        if (superPomDrivingMinVersion) {
            this.logLine(false, "Note: the super-pom from Maven " + curMavenVersion + " defines some of the plugin");
            this.logLine(false, "      versions and may be influencing the plugins required minimum Maven");
            this.logLine(false, "      version.");
        }
        this.logLine(false, "");
        if (this.isMavenPluginProject()) {
            if (noMavenMinVersion) {
                this.getLog().warn((CharSequence)"Project (which is a Maven plugin) does not define required minimum version of Maven.");
                this.getLog().warn((CharSequence)"Update the pom.xml to contain");
                this.getLog().warn((CharSequence)"    <prerequisites>");
                this.getLog().warn((CharSequence)"      <maven><!-- minimum version of Maven that the plugin works with --></maven>");
                this.getLog().warn((CharSequence)"    </prerequisites>");
                this.getLog().warn((CharSequence)("To build this plugin you need at least Maven " + minMavenVersion));
                this.getLog().warn((CharSequence)"A Maven Enforcer rule can be used to enforce this if you have not already set one up");
                this.getLog().warn((CharSequence)"See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            } else if (minMavenVersion != null && DisplayPluginUpdatesMojo.compare(specMavenVersion, minMavenVersion) < 0) {
                this.getLog().warn((CharSequence)("Project (which is a Maven plugin) targets Maven " + specMavenVersion + " or newer"));
                this.getLog().warn((CharSequence)("but requires Maven " + minMavenVersion + " or newer to build."));
                this.getLog().warn((CharSequence)"This may or may not be a problem. A Maven Enforcer rule can help ");
                this.getLog().warn((CharSequence)"enforce that the correct version of Maven is used to build this plugin.");
                this.getLog().warn((CharSequence)"See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            } else {
                this.logLine(false, "No plugins require a newer version of Maven than specified by the pom.");
            }
        } else if (noMavenMinVersion) {
            this.logLine(true, "Project does not define required minimum version of Maven.");
            this.logLine(true, "Update the pom.xml to contain maven-enforcer-plugin to");
            this.logLine(true, "force the Maven version which is needed to build this project.");
            this.logLine(true, "See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            this.logLine(true, "Using the minimum version of Maven: " + minMavenVersion);
        } else if (minMavenVersion != null && DisplayPluginUpdatesMojo.compare(specMavenVersion, minMavenVersion) < 0) {
            this.logLine(true, "Project requires an incorrect minimum version of Maven.");
            this.logLine(true, "Update the pom.xml to contain maven-enforcer-plugin to");
            this.logLine(true, "force the Maven version which is needed to build this project.");
            this.logLine(true, "See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            this.logLine(true, "Using the minimum version of Maven: " + specMavenVersion);
        } else {
            this.logLine(false, "No plugins require a newer version of Maven than specified by the pom.");
        }
        for (Map.Entry mavenUpgrade : mavenUpgrades.entrySet()) {
            ArtifactVersion mavenUpgradeVersion = (ArtifactVersion)mavenUpgrade.getKey();
            Map upgradePlugins = (Map)mavenUpgrade.getValue();
            if (upgradePlugins.isEmpty() || DisplayPluginUpdatesMojo.compare(specMavenVersion, mavenUpgradeVersion) >= 0) continue;
            this.logLine(false, "");
            this.logLine(false, "Require Maven " + mavenUpgradeVersion + " to use the following plugin updates:");
            for (Map.Entry entry : upgradePlugins.entrySet()) {
                this.logLine(false, (String)entry.getValue());
            }
        }
        this.logLine(false, "");
    }

    private MavenProject getPluginProject(String groupId, String artifactId, String version) throws MojoExecutionException, ProjectBuildingException, ArtifactResolutionException {
        Artifact probe = this.getHelper().createDependencyArtifact(DependencyBuilder.newBuilder().withGroupId(groupId).withArtifactId(artifactId).withVersion(version).withType("pom").withScope("runtime").build());
        this.getHelper().resolveArtifact(probe, true);
        ProjectBuildingResult result = this.projectBuilder.build(probe, true, PomHelper.createProjectBuilderRequest((MavenSession)this.session, (Consumer[])new Consumer[]{r -> r.setProcessPlugins(false), r -> r.setRemoteRepositories(this.session.getCurrentProject().getPluginArtifactRepositories())}));
        if (!result.getProblems().isEmpty()) {
            this.getLog().warn((CharSequence)("Problems encountered during construction of the plugin POM for " + probe.toString()));
            result.getProblems().forEach(p -> this.getLog().warn((CharSequence)("\t" + p.getMessage())));
        }
        return result.getProject();
    }

    private static String pad(String start, int len, String ... ends) {
        StringBuilder buf = new StringBuilder(len);
        buf.append("  ");
        buf.append(start);
        int padding = len;
        for (String end : ends) {
            padding -= end.length();
        }
        buf.append(' ');
        while (buf.length() < padding) {
            buf.append('.');
        }
        buf.append(' ');
        for (String end : ends) {
            buf.append(end);
        }
        return buf.toString();
    }

    private Map<String, String> getParentsPlugins(List<MavenProject> parents) throws MojoExecutionException {
        HashMap<String, String> parentPlugins = new HashMap<String, String>();
        for (MavenProject parentProject : parents) {
            this.getLog().debug((CharSequence)("Processing parent: " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " -> " + parentProject.getFile()));
            StringWriter writer = new StringWriter();
            boolean havePom = false;
            Model originalModel = parentProject.getOriginalModel();
            if (originalModel == null) {
                this.getLog().warn((CharSequence)("project.getOriginalModel()==null for  " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " is null, substituting project.getModel()"));
                originalModel = parentProject.getModel();
            }
            try {
                new MavenXpp3Writer().write((Writer)writer, originalModel);
                writer.close();
                havePom = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest();
            modelBuildingRequest.setUserProperties(this.getProject().getProperties());
            Model interpolatedModel = this.modelInterpolator.interpolateModel(originalModel, null, (ModelBuildingRequest)modelBuildingRequest, (ModelProblemCollector)new IgnoringModelProblemCollector());
            if (havePom) {
                try {
                    Set<String> withVersionSpecified = this.findPluginsWithVersionsSpecified(new StringBuilder(writer.toString()), this.getSafeProjectPathInfo(parentProject));
                    Map<String, String> map = this.getPluginManagement(interpolatedModel);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPlugins.putAll(map);
                    map = this.getBuildPlugins(interpolatedModel, true);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPlugins.putAll(map);
                    map = this.getReportPlugins(interpolatedModel, true);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPlugins.putAll(map);
                    continue;
                }
                catch (XMLStreamException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            parentPlugins.putAll(this.getPluginManagement(interpolatedModel));
            parentPlugins.putAll(this.getBuildPlugins(interpolatedModel, true));
            parentPlugins.putAll(this.getReportPlugins(interpolatedModel, true));
        }
        return parentPlugins;
    }

    private String getSafeProjectPathInfo(MavenProject project) {
        return Optional.ofNullable(project.getFile()).map(File::getAbsolutePath).orElse(project.toString());
    }

    private boolean isMavenPluginProject() {
        return "maven-plugin".equals(this.getProject().getPackaging());
    }

    private String compactKey(String groupId, String artifactId) {
        return "org.apache.maven.plugins".equals(groupId) ? artifactId : groupId + ":" + artifactId;
    }

    private Set<String> findPluginsWithVersionsSpecified(StringBuilder pomContents, String path) throws XMLStreamException {
        HashSet<String> result = new HashSet<String>();
        ModifiedPomXMLEventReader pom = this.newModifiedPomXER(pomContents, path);
        Pattern pathRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
        Stack<StackState> pathStack = new Stack<StackState>();
        StackState curState = null;
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartDocument()) {
                curState = new StackState("");
                pathStack.clear();
                continue;
            }
            if (event.isStartElement()) {
                String elementName = event.asStartElement().getName().getLocalPart();
                if (curState != null && pathRegex.matcher(curState.path).matches()) {
                    if ("groupId".equals(elementName)) {
                        curState.groupId = pom.getElementText().trim();
                        continue;
                    }
                    if ("artifactId".equals(elementName)) {
                        curState.artifactId = pom.getElementText().trim();
                        continue;
                    }
                    if ("version".equals(elementName)) {
                        curState.version = pom.getElementText().trim();
                        continue;
                    }
                }
                pathStack.push(curState);
                curState = new StackState(curState.path + "/" + elementName);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (curState != null && pathRegex.matcher(curState.path).matches() && curState.artifactId != null && curState.version != null) {
                if (curState.groupId == null) {
                    curState.groupId = "org.apache.maven.plugins";
                }
                result.add(curState.groupId + ":" + curState.artifactId);
            }
            curState = (StackState)pathStack.pop();
        }
        return result;
    }

    private ArtifactVersion getPrerequisitesMavenVersion(MavenProject pluginProject) {
        return (ArtifactVersion)Optional.ofNullable(pluginProject.getPrerequisites()).map(Prerequisites::getMaven).map(DefaultArtifactVersion::new).orElse(new DefaultArtifactVersion(DEFAULT_MVN_VERSION));
    }

    private Map<String, String> getPluginsFromBuild(BuildBase build, boolean onlyIncludeInherited) {
        return Optional.ofNullable(build).flatMap(b -> Optional.ofNullable(b.getPlugins()).map(plugins -> plugins.stream().filter(plugin -> plugin.getVersion() != null).filter(plugin -> !onlyIncludeInherited || DisplayPluginUpdatesMojo.getPluginInherited(plugin)).collect(Collectors.toMap(Plugin::getKey, Plugin::getVersion)))).orElse(Collections.emptyMap());
    }

    private Map<String, String> getBuildPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> buildPlugins = new HashMap<String, String>(this.getPluginsFromBuild((BuildBase)model.getBuild(), onlyIncludeInherited));
        Optional.ofNullable(model.getProfiles()).ifPresent(profiles -> profiles.stream().map(profile -> this.getPluginsFromBuild(profile.getBuild(), onlyIncludeInherited)).forEach(buildPlugins::putAll));
        return buildPlugins;
    }

    private static boolean getPluginInherited(Object plugin) {
        return "true".equalsIgnoreCase(plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getInherited() : ((Plugin)plugin).getInherited());
    }

    private Map<String, Plugin> getLifecyclePlugins(MavenProject project) throws MojoExecutionException {
        return this.getBoundPlugins(project).parallelStream().filter(Objects::nonNull).filter(p -> p.getKey() != null).collect(HashMap::new, (m, p) -> m.put(p.getKey(), p), Map::putAll);
    }

    private Set<Plugin> getBoundPlugins(MavenProject project) {
        return this.lifecycleExecutor.getPluginsBoundByDefaultToAllLifecycles(project.getPackaging()).parallelStream().map(p -> new Plugin((Plugin)p){
            final /* synthetic */ Plugin val$p;
            {
                this.val$p = plugin;
                this.setGroupId(this.val$p.getGroupId());
                this.setArtifactId(this.val$p.getArtifactId());
            }
        }).collect(Collectors.toSet());
    }

    private List<MavenProject> getParentProjects(MavenProject project) throws MojoExecutionException {
        ArrayList<MavenProject> parents = new ArrayList<MavenProject>();
        while (project.getParent() != null) {
            project = project.getParent();
            parents.add(0, project);
        }
        return parents;
    }

    private Set<Plugin> getProjectPlugins(Map<String, String> superPomPluginManagement, Map<String, String> parentPluginManagement, Map<String, String> parentBuildPlugins, Map<String, String> parentReportPlugins, Set<String> pluginsWithVersionsSpecified) throws MojoExecutionException {
        String parentVersion;
        Iterator i;
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        this.getLog().debug((CharSequence)"Building list of project plugins...");
        if (this.getLog().isDebugEnabled()) {
            StringWriter origModel = new StringWriter();
            try {
                origModel.write("Original model:\n");
                this.getProject().writeOriginalModel((Writer)origModel);
                this.getLog().debug((CharSequence)origModel.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.debugVersionMap("super-pom version map", superPomPluginManagement);
        this.debugVersionMap("parent version map", parentPluginManagement);
        HashMap<String, String> excludePluginManagement = new HashMap<String, String>(superPomPluginManagement);
        excludePluginManagement.putAll(parentPluginManagement);
        this.debugVersionMap("aggregate version map", excludePluginManagement);
        excludePluginManagement.keySet().removeAll(pluginsWithVersionsSpecified);
        this.debugVersionMap("final aggregate version map", excludePluginManagement);
        DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest();
        modelBuildingRequest.setUserProperties(this.getProject().getProperties());
        Model originalModel = this.modelInterpolator.interpolateModel(this.getProject().getOriginalModel(), this.getProject().getBasedir(), (ModelBuildingRequest)modelBuildingRequest, (ModelProblemCollector)new IgnoringModelProblemCollector());
        try {
            this.addProjectPlugins(plugins, originalModel.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.debugPluginMap("after adding local pluginManagement", plugins);
        try {
            ArrayList<Plugin> lifecyclePlugins = new ArrayList<Plugin>(this.getLifecyclePlugins(this.getProject()).values());
            i = lifecyclePlugins.iterator();
            while (i.hasNext()) {
                Plugin lifecyclePlugin = (Plugin)i.next();
                if (lifecyclePlugin.getVersion() != null) {
                    i.remove();
                    continue;
                }
                parentVersion = parentPluginManagement.get(lifecyclePlugin.getKey());
                if (parentVersion == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, lifecyclePlugins, parentPluginManagement);
            this.debugPluginMap("after adding lifecycle plugins", plugins);
        }
        catch (NullPointerException lifecyclePlugins) {
            // empty catch block
        }
        try {
            ArrayList<Plugin> buildPlugins = new ArrayList<Plugin>(originalModel.getBuild().getPlugins());
            i = buildPlugins.iterator();
            while (i.hasNext()) {
                Plugin buildPlugin = (Plugin)i.next();
                if (buildPlugin.getVersion() != null || (parentVersion = parentPluginManagement.get(buildPlugin.getKey())) == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, buildPlugins, parentBuildPlugins);
        }
        catch (NullPointerException buildPlugins) {
            // empty catch block
        }
        this.debugPluginMap("after adding build plugins", plugins);
        try {
            ArrayList reportPlugins = new ArrayList(originalModel.getReporting().getPlugins());
            i = reportPlugins.iterator();
            while (i.hasNext()) {
                ReportPlugin reportPlugin = (ReportPlugin)i.next();
                if (reportPlugin.getVersion() != null || (parentVersion = parentPluginManagement.get(reportPlugin.getKey())) == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, DisplayPluginUpdatesMojo.toPlugins(reportPlugins), parentReportPlugins);
        }
        catch (NullPointerException reportPlugins) {
            // empty catch block
        }
        this.debugPluginMap("after adding reporting plugins", plugins);
        for (Profile profile : originalModel.getProfiles()) {
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.debugPluginMap("after adding build pluginManagement for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPlugins(), parentBuildPlugins);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.debugPluginMap("after adding build plugins for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, DisplayPluginUpdatesMojo.toPlugins(profile.getReporting().getPlugins()), parentReportPlugins);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.debugPluginMap("after adding reporting plugins for profile " + profile.getId(), plugins);
        }
        TreeSet<Plugin> result = new TreeSet<Plugin>((Comparator<Plugin>)PluginComparator.INSTANCE);
        result.addAll(plugins.values());
        return result;
    }

    private void addProjectPlugins(Map<String, Plugin> plugins, Collection<Plugin> projectPlugins, Map<String, String> parentDefinitions) {
        for (Plugin plugin : projectPlugins) {
            String coord = plugin.getKey();
            String version = plugin.getVersion();
            String parentVersion = parentDefinitions.get(coord);
            if (!(version != null || plugins.containsKey(coord) && plugins.get(coord).getVersion() != null || parentVersion == null)) {
                Plugin parentPlugin = new Plugin();
                parentPlugin.setGroupId(plugin.getGroupId());
                parentPlugin.setArtifactId(plugin.getArtifactId());
                parentPlugin.setVersion(parentVersion);
                plugins.put(coord, parentPlugin);
            } else if (!(parentVersion != null && parentVersion.equals(version) || plugins.containsKey(coord) && plugins.get(coord).getVersion() != null)) {
                plugins.put(coord, plugin);
            }
            if (plugins.containsKey(coord)) continue;
            plugins.put(coord, plugin);
        }
    }

    private void debugPluginMap(String description, Map<String, Plugin> plugins) {
        if (this.getLog().isDebugEnabled()) {
            TreeSet<Plugin> sorted = new TreeSet<Plugin>((Comparator<Plugin>)PluginComparator.INSTANCE);
            sorted.addAll(plugins.values());
            StringBuilder buf = new StringBuilder(description);
            for (Plugin plugin : sorted) {
                buf.append("\n    ");
                buf.append(plugin.getKey());
                buf.append(":");
                buf.append(plugin.getVersion());
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private void debugVersionMap(String description, Map<String, String> pluginVersions) {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(description);
            for (Map.Entry<String, String> pluginVersion : pluginVersions.entrySet()) {
                buf.append("\n    ");
                buf.append(pluginVersion.getKey());
                buf.append(":");
                buf.append(pluginVersion.getValue());
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private static Plugin toPlugin(ReportPlugin reportPlugin) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        plugin.setVersion(reportPlugin.getVersion());
        return plugin;
    }

    private static List<Plugin> toPlugins(List<ReportPlugin> reportPlugins) {
        ArrayList<Plugin> result = new ArrayList<Plugin>(reportPlugins.size());
        for (ReportPlugin reportPlugin : reportPlugins) {
            result.add(DisplayPluginUpdatesMojo.toPlugin(reportPlugin));
        }
        return result;
    }

    private Map<String, String> getReportPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> reportPlugins = new HashMap<String, String>();
        try {
            for (ReportPlugin plugin : model.getReporting().getPlugins()) {
                String coord = plugin.getKey();
                String version = plugin.getVersion();
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                reportPlugins.put(coord, version);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (ReportPlugin plugin : profile.getReporting().getPlugins()) {
                        String coord = plugin.getKey();
                        String version = plugin.getVersion();
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        reportPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return reportPlugins;
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) {
    }

    private static int compare(ArtifactVersion a, ArtifactVersion b) {
        return a.compareTo((Object)b);
    }

    private static class IgnoringModelProblemCollector
    implements ModelProblemCollector {
        private IgnoringModelProblemCollector() {
        }

        public void add(ModelProblemCollectorRequest req) {
        }
    }

    private static final class StackState {
        private final String path;
        private String groupId;
        private String artifactId;
        private String version;

        StackState(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path + "[groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
        }
    }
}

