/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.BoundArtifactVersion;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.SegmentUtils;

@Mojo(name="use-latest-snapshots", threadSafe=true)
public class UseLatestSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="allowMajorUpdates", defaultValue="false")
    protected boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="false")
    protected boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates;
    private final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    @Inject
    public UseLatestSnapshotsMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        super(repositorySystem, projectBuilder, artifactMetadataSource, wagonManager, artifactResolver);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useLatestSnapshots(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useLatestSnapshots(pom, this.getProject().getDependencies());
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useLatestSnapshots(pom, Collections.singletonList(DependencyBuilder.newBuilder().withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withVersion(this.getProject().getParent().getVersion()).withType("pom").build()));
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useLatestSnapshots(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        Optional<Segment> unchangedSegment = SegmentUtils.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates, this.getLog());
        for (Dependency dep : dependencies) {
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (versionMatcher.matches()) continue;
            this.getLog().debug((CharSequence)("Looking for latest snapshot of " + this.toString(dep)));
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            DefaultArtifactVersion selectedVersion = new DefaultArtifactVersion(version);
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            VersionComparator versionComparator = versions.getVersionComparator();
            DefaultArtifactVersion lowerBound = new DefaultArtifactVersion(version);
            if (unchangedSegment.isPresent() && unchangedSegment.get().value() >= versionComparator.getSegmentCount((ArtifactVersion)lowerBound)) {
                this.getLog().info((CharSequence)("Ignoring " + this.toString(dep) + " as the version number is too short"));
                continue;
            }
            ArtifactVersion upperBound = unchangedSegment.map(s -> new BoundArtifactVersion((ArtifactVersion)lowerBound, Segment.of(s.value() + 1))).orElse(null);
            this.getLog().info((CharSequence)("Upper bound: " + (upperBound == null ? "none" : upperBound.toString())));
            Restriction restriction = new Restriction((ArtifactVersion)lowerBound, false, upperBound, false);
            ArtifactVersion[] newer = versions.getVersions(restriction, true);
            this.getLog().debug((CharSequence)("Candidate versions " + Arrays.asList(newer)));
            ArrayList<ArtifactVersion> snapshotsOnly = new ArrayList<ArtifactVersion>();
            for (ArtifactVersion artifactVersion : newer) {
                String newVersion = artifactVersion.toString();
                if (!this.matchSnapshotRegex.matcher(newVersion).matches()) continue;
                snapshotsOnly.add(artifactVersion);
            }
            ArtifactVersion[] filteredVersions = snapshotsOnly.toArray(new ArtifactVersion[snapshotsOnly.size()]);
            if (filteredVersions.length <= 0) continue;
            String latestVersion = filteredVersions[filteredVersions.length - 1].toString();
            if (this.getProject().getParent() != null) {
                Artifact parentArtifact = this.getProject().getParentArtifact();
                if (artifact.getId().equals(parentArtifact.getId()) && this.isProcessingParent() && PomHelper.setProjectParentVersion(pom, latestVersion)) {
                    this.getLog().debug((CharSequence)("Made parent update from " + version + " to " + latestVersion));
                    this.getChangeRecorder().recordUpdate("useLatestSnapshots", parentArtifact.getGroupId(), parentArtifact.getArtifactId(), version, latestVersion);
                }
            }
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, latestVersion, this.getProject().getModel())) continue;
            this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + latestVersion));
            this.getChangeRecorder().recordUpdate("useLatestSnapshots", dep.getGroupId(), dep.getArtifactId(), version, latestVersion);
        }
    }
}

