/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.SegmentUtils;

@Mojo(name="update-parent", threadSafe=true)
public class UpdateParentMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="parentVersion")
    protected String parentVersion = null;
    @Parameter(property="forceUpdate", defaultValue="false")
    protected boolean forceUpdate = false;
    @Parameter(property="skipResolution", defaultValue="false")
    protected boolean skipResolution = false;
    @Parameter(property="allowDowngrade", defaultValue="false")
    protected boolean allowDowngrade;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates = true;

    @Inject
    public UpdateParentMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        super(repositorySystem, projectBuilder, artifactMetadataSource, wagonManager, artifactResolver);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        if (this.getProject().getParent() == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        if (this.skipResolution && StringUtils.isBlank((String)this.parentVersion)) {
            throw new MojoExecutionException("skipResolution is only valid if parentVersion is set");
        }
        String initialVersion = this.parentVersion == null ? this.getProject().getParent().getVersion() : this.parentVersion;
        try {
            DefaultArtifactVersion artifactVersion;
            Object object = artifactVersion = this.skipResolution ? new DefaultArtifactVersion(this.parentVersion) : this.resolveTargetVersion(initialVersion);
            if (artifactVersion != null) {
                this.getLog().info((CharSequence)("Updating parent from " + this.getProject().getParent().getVersion() + " to " + artifactVersion));
                if (PomHelper.setProjectParentVersion(pom, artifactVersion.toString())) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Made an update from " + this.getProject().getParent().getVersion() + " to " + artifactVersion));
                    }
                    this.getChangeRecorder().recordUpdate("updateParent", this.getProject().getParent().getGroupId(), this.getProject().getParent().getArtifactId(), this.getProject().getParent().getVersion(), artifactVersion.toString());
                }
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Invalid version range specification: " + initialVersion, (Exception)((Object)e));
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidSegmentException e) {
            throw new MojoExecutionException("Invalid segment specification for version " + initialVersion, (Exception)e);
        }
    }

    protected ArtifactVersion resolveTargetVersion(String initialVersion) throws MojoExecutionException, ArtifactMetadataRetrievalException, InvalidVersionSpecificationException, InvalidSegmentException {
        Artifact artifact = this.getHelper().createDependencyArtifact(DependencyBuilder.newBuilder().withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withVersion(initialVersion).withType("pom").build());
        VersionRange targetVersionRange = VersionRange.createFromVersionSpec((String)initialVersion);
        if (targetVersionRange.getRecommendedVersion() != null) {
            targetVersionRange = targetVersionRange.restrict(VersionRange.createFromVersionSpec((String)("[" + targetVersionRange.getRecommendedVersion() + ",)")));
        }
        ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
        Optional<Segment> unchangedSegment = SegmentUtils.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates, this.getLog());
        for (ArtifactVersion candidate : UpdateParentMojo.reverse(versions.getNewerVersions(initialVersion, unchangedSegment, this.allowSnapshots, !StringUtils.isBlank((String)this.parentVersion) || this.allowDowngrade))) {
            if (!this.allowDowngrade && targetVersionRange != null && !ArtifactVersions.isVersionInRange(candidate, targetVersionRange)) continue;
            if (this.shouldApplyUpdate(artifact, this.getProject().getParent().getVersion(), candidate, this.forceUpdate)) {
                return candidate;
            }
            this.getLog().debug((CharSequence)"Update not applied. Exiting.");
            return null;
        }
        this.getLog().info((CharSequence)"No versions found");
        return null;
    }

    private static <T> Iterable<T> reverse(T[] array) {
        return Arrays.stream(array).sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }
}

