/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.checkout;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListCommand;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitCheckOutCommand
extends AbstractCheckOutCommand
implements GitCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive) throws ScmException {
        Commandline clPull;
        int exitCode;
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if ("file".equals(repository.getFetchInfo().getProtocol()) && repository.getFetchInfo().getPath().indexOf(fileSet.getBasedir().getPath()) >= 0) {
            throw new ScmException("remote repository must not be the working directory");
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (!fileSet.getBasedir().exists() || !new File(fileSet.getBasedir(), ".git").exists()) {
            Commandline clClone;
            if (fileSet.getBasedir().exists()) {
                fileSet.getBasedir().delete();
            }
            if ((exitCode = GitCommandLineUtils.execute(clClone = this.createCloneCommand(repository, fileSet.getBasedir()), stdout, stderr, this.getLogger())) != 0) {
                return new CheckOutScmResult(clClone.toString(), "The git-clone command failed.", stderr.getOutput(), false);
            }
        }
        if (fileSet.getBasedir().exists() && new File(fileSet.getBasedir(), ".git").exists() && (exitCode = GitCommandLineUtils.execute(clPull = this.createPullCommand(repository, fileSet.getBasedir(), version), stdout, stderr, this.getLogger())) != 0) {
            return new CheckOutScmResult(clPull.toString(), "The git-pull command failed.", stderr.getOutput(), false);
        }
        Commandline cl = GitCheckOutCommand.createCommandLine(repository, fileSet.getBasedir(), version);
        exitCode = GitCommandLineUtils.execute(cl, stdout, stderr, this.getLogger());
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The git-checkout command failed.", stderr.getOutput(), false);
        }
        GitListConsumer listConsumer = new GitListConsumer(this.getLogger(), fileSet.getBasedir(), ScmFileStatus.CHECKED_IN);
        Commandline clList = GitListCommand.createCommandLine(repository, fileSet.getBasedir());
        exitCode = GitCommandLineUtils.execute(clList, listConsumer, stderr, this.getLogger());
        if (exitCode != 0) {
            return new CheckOutScmResult(clList.toString(), "The git-ls-files command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(cl.toString(), listConsumer.getListedFiles());
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, ScmVersion version) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "checkout");
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            cl.createArg().setValue(version.getName());
        }
        return cl;
    }

    private Commandline createCloneCommand(GitScmProviderRepository repository, File workingDirectory) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory.getParentFile(), "clone");
        cl.createArg().setValue(repository.getFetchUrl());
        cl.createArg().setFile(workingDirectory);
        return cl;
    }

    private Commandline createPullCommand(GitScmProviderRepository repository, File workingDirectory, ScmVersion version) {
        Commandline cl;
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            if (version instanceof ScmTag) {
                cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "fetch");
                cl.createArg().setValue(repository.getFetchUrl());
            } else {
                cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "pull");
                cl.createArg().setValue(repository.getFetchUrl());
                cl.createArg().setValue(version.getName() + ":" + version.getName());
            }
        } else {
            cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "pull");
            cl.createArg().setValue(repository.getFetchUrl());
            cl.createArg().setValue("master");
        }
        return cl;
    }
}

