/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;

public abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    static final ThreadLocal<char[]> SHORT_STRING_BUFFER = new ThreadLocal();
    public static final int SHORT_STRING_LENGTH = 256;

    Platform() {
    }

    public static char[] shortStringBuffer() {
        char[] shortStringBuffer = SHORT_STRING_BUFFER.get();
        if (shortStringBuffer == null) {
            shortStringBuffer = new char[256];
            SHORT_STRING_BUFFER.set(shortStringBuffer);
        }
        return shortStringBuffer;
    }

    public RuntimeException uncheckedIOException(IOException e) {
        return new RuntimeException(e);
    }

    public AssertionError assertionError(String message, Throwable cause) {
        AssertionError error = new AssertionError((Object)message);
        ((Throwable)((Object)error)).initCause(cause);
        throw error;
    }

    public static Platform get() {
        return PLATFORM;
    }

    static Platform findPlatform() {
        try {
            Class.forName("java.io.UncheckedIOException");
            return new Jre8();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("java.util.concurrent.ThreadLocalRandom");
                return new Jre7();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return Jre6.build();
            }
        }
    }

    static final class Jre8
    extends Jre7 {
        Jre8() {
        }

        @Override
        @IgnoreJRERequirement
        public RuntimeException uncheckedIOException(IOException e) {
            return new UncheckedIOException(e);
        }
    }

    static class Jre7
    extends Platform {
        Jre7() {
        }

        @Override
        @IgnoreJRERequirement
        public AssertionError assertionError(String message, Throwable cause) {
            return new AssertionError(message, cause);
        }
    }

    static final class Jre6
    extends Platform {
        Jre6() {
        }

        static Jre6 build() {
            return new Jre6();
        }
    }
}

