/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.security.encrypt;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorAdaptor;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.gm.base.utils.SmUtils;
import com.yeepay.yop.sdk.gm.utils.Sm4Utils;
import com.yeepay.yop.sdk.security.encrypt.BigParamEncryptMode;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.Encodes;
import com.yeepay.yop.sdk.utils.RandomUtils;
import java.io.InputStream;
import java.security.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jcajce.io.CipherInputStream;

public class YopSm4Encryptor
extends YopEncryptorAdaptor {
    public static final String SECRET_KEY_TYPE = "SM4";
    public static final String ALGORITHM_NAME_GCM_NOPADDING = "SM4/GCM/NoPadding";
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private static final ThreadLocal<Map<String, Cipher>> cipherThreadLocal;

    public List<String> supportedAlgs() {
        return Arrays.asList("SM4/CBC/PKCS5Padding", ALGORITHM_NAME_GCM_NOPADDING);
    }

    public EncryptOptions doInitEncryptOptions(String encryptAlg) throws Exception {
        return new EncryptOptions((Object)new YopSymmetricCredentials(Encodes.encodeUrlSafeBase64((byte[])Sm4Utils.generateKey())), "SM2", encryptAlg, Encodes.encodeUrlSafeBase64((byte[])RandomUtils.secureRandom().generateSeed(16)), Encodes.encodeUrlSafeBase64((byte[])"yop".getBytes("UTF-8")));
    }

    public byte[] encrypt(byte[] plain, EncryptOptions options) {
        try {
            Cipher initializedCipher = this.getInitializedCipher(1, options);
            return initializedCipher.doFinal(plain);
        }
        catch (Throwable t) {
            throw new YopClientException("error happened when encrypt data", t);
        }
    }

    public InputStream encrypt(InputStream plain, EncryptOptions options) {
        if (BigParamEncryptMode.chunked.equals((Object)options.getBigParamEncryptMode())) {
            throw new YopClientException("chunked encrypt for files not supported now");
        }
        return new CipherInputStream(plain, this.getInitializedCipher(1, options, false));
    }

    public byte[] decrypt(byte[] cipher, EncryptOptions options) {
        try {
            Cipher initializedCipher = this.getInitializedCipher(2, options);
            return initializedCipher.doFinal(cipher);
        }
        catch (Throwable t) {
            throw new YopClientException("error happened when decrypt data", t);
        }
    }

    public InputStream decrypt(InputStream cipher, EncryptOptions options) {
        if (BigParamEncryptMode.chunked.equals((Object)options.getBigParamEncryptMode())) {
            throw new YopClientException("chunked decrypt for files not supported now");
        }
        return new CipherInputStream(cipher, this.getInitializedCipher(2, options, false));
    }

    private Cipher getInitializedCipher(int mode, EncryptOptions encryptOptions) {
        return this.getInitializedCipher(mode, encryptOptions, true);
    }

    private Cipher getInitializedCipher(int mode, EncryptOptions encryptOptions, boolean shareMode) {
        try {
            byte[] key = Encodes.decodeBase64((String)((YopSymmetricCredentials)encryptOptions.getCredentials()).getCredential());
            Cipher cipher = shareMode ? cipherThreadLocal.get().get(encryptOptions.getAlg()) : Cipher.getInstance(encryptOptions.getAlg(), "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(key, SECRET_KEY_TYPE);
            if (ALGORITHM_NAME_GCM_NOPADDING.equals(encryptOptions.getAlg())) {
                String nonce = encryptOptions.getIv();
                byte[] nonceBytes = null != nonce ? Encodes.decodeBase64((String)nonce) : new byte[12];
                GCMParameterSpec spec = new GCMParameterSpec(128, nonceBytes);
                cipher.init(mode, (Key)sm4Key, spec);
                if (StringUtils.isNotBlank((CharSequence)encryptOptions.getAad())) {
                    cipher.updateAAD(encryptOptions.getAad().getBytes("UTF-8"));
                }
                return cipher;
            }
            if (StringUtils.isNotEmpty((CharSequence)encryptOptions.getIv())) {
                byte[] ivBytes = Encodes.decodeBase64((String)encryptOptions.getIv());
                IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
                cipher.init(mode, (Key)sm4Key, ivParameterSpec);
                return cipher;
            }
            cipher.init(mode, sm4Key);
            return cipher;
        }
        catch (Throwable throwable) {
            throw new YopClientException("error happened when initialize cipher", throwable);
        }
    }

    static {
        SmUtils.init();
        cipherThreadLocal = new ThreadLocal<Map<String, Cipher>>(){

            @Override
            protected Map<String, Cipher> initialValue() {
                HashMap map = Maps.newHashMap();
                try {
                    map.put("SM4/CBC/PKCS5Padding", Cipher.getInstance("SM4/CBC/PKCS5Padding", "BC"));
                    map.put(YopSm4Encryptor.ALGORITHM_NAME_GCM_NOPADDING, Cipher.getInstance(YopSm4Encryptor.ALGORITHM_NAME_GCM_NOPADDING, "BC"));
                }
                catch (Exception e) {
                    throw new YopClientException("error happened when initial with SM4 alg", (Throwable)e);
                }
                return map;
            }
        };
    }
}

