/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.security.cert.parser;

import com.yeepay.yop.sdk.base.security.cert.parser.AbstractYopPrivateKeyParser;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParser;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.gm.utils.Sm2Utils;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import org.apache.commons.lang3.StringUtils;

public class YopSm2PrivateKeyParser
extends AbstractYopPrivateKeyParser
implements YopCertParser {
    public PrivateKey parse(YopCertConfig certConfig) {
        if (null == certConfig.getStoreType()) {
            throw new YopClientException("Can't init ISV private key! Store type is error.");
        }
        switch (certConfig.getStoreType()) {
            case STRING: {
                try {
                    return Sm2Utils.string2PrivateKey(certConfig.getValue());
                }
                catch (Exception ex) {
                    throw new YopClientException("Failed to init private key form config file is error, " + certConfig, (Throwable)ex);
                }
            }
            case FILE_P12: {
                try {
                    return this.parsePrivateKey(certConfig.getPassword(), certConfig.getValue());
                }
                catch (Exception ex) {
                    throw new YopClientException("Config wrong for private_key, cert_config:" + certConfig, (Throwable)ex);
                }
            }
        }
        throw new YopClientException("Config wrong for cert store_type not supported, " + certConfig.getStoreType());
    }

    public String parserId() {
        return StringUtils.joinWith((String)",", (Object[])new Object[]{YopCertCategory.PRIVATE, CertTypeEnum.SM2});
    }

    protected KeyStore getKeyStore() throws KeyStoreException, NoSuchProviderException {
        return KeyStore.getInstance("PKCS12", "BC");
    }
}

