/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import com.mks.api.CmdRunner;
import com.mks.api.Command;
import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Option;
import com.mks.api.Session;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import java.io.IOException;

public class GenerateAPIStats {
    private static String host;
    private static int port;
    private static String user;
    private static String pass;
    private static String command_domain;
    private static String command;
    private static int test_count;
    private static String impersonated_user;

    GenerateAPIStats(int testCase) {
        try {
            switch (testCase) {
                case 1: {
                    this.testCommandClean();
                    break;
                }
                case 2: {
                    this.testCommandSlowClean();
                    break;
                }
                case 3: {
                    this.testCommandSlowDirty();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal test case.");
                }
            }
        }
        catch (APIException apie) {
            System.out.print(apie.getMessage());
        }
    }

    private Session connect() throws APIException {
        IntegrationPointFactory ipf = IntegrationPointFactory.getInstance();
        IntegrationPoint ip = ipf.createIntegrationPoint(host, port, false, 0, 0);
        return ip.createSession(user, pass);
    }

    private void disconnect(Session session) throws APIException {
        if (session != null) {
            try {
                session.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCommandClean() throws APIException {
        CmdRunner runner;
        Session session;
        block6: {
            session = null;
            Response response = null;
            runner = null;
            try {
                session = this.connect();
                runner = session.createCmdRunner();
                for (int i = 0; i < test_count; ++i) {
                    response = this.executeCommand(runner);
                }
                Object var6_5 = null;
                if (response == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (response != null) {
                    response.release();
                }
                if (runner != null) {
                    runner.release();
                }
                this.disconnect(session);
                throw throwable;
            }
            response.release();
        }
        if (runner != null) {
            runner.release();
        }
        this.disconnect(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCommandSlowClean() throws APIException {
        Session session = null;
        Response response = null;
        CmdRunner runner = null;
        for (int i = 0; i < test_count; ++i) {
            block6: {
                Object var6_5;
                try {
                    session = this.connect();
                    runner = session.createCmdRunner();
                    response = this.executeCommand(runner);
                    var6_5 = null;
                    if (response == null) break block6;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    if (response != null) {
                        response.release();
                    }
                    if (runner != null) {
                        runner.release();
                    }
                    this.disconnect(session);
                    throw throwable;
                }
                response.release();
            }
            if (runner != null) {
                runner.release();
            }
            this.disconnect(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCommandSlowDirty() throws APIException {
        Session session = null;
        Response response = null;
        CmdRunner runner = null;
        for (int i = 0; i < test_count; ++i) {
            session = this.connect();
            runner = session.createCmdRunner();
            response = this.executeCommand(runner);
            continue;
        }
    }

    private Response executeCommand(CmdRunner runner) throws APIException {
        Response response;
        APIException apie;
        Command cmd = new Command(command_domain, command);
        if (impersonated_user != null) {
            cmd.addOption(new Option("impersonateuser", impersonated_user));
        }
        if ((apie = (response = runner.execute(cmd)).getAPIException()) != null) {
            throw apie;
        }
        return response;
    }

    public static void main(String[] args) {
        int testCase = 0;
        if (args == null || args.length < 8) {
            throw new IllegalArgumentException();
        }
        host = args[0];
        port = new Integer(args[1]);
        user = args[2];
        pass = args[3];
        command_domain = args[4];
        command = args[5];
        test_count = new Integer(args[6]);
        testCase = new Integer(args[7]);
        if (args[8] != null) {
            impersonated_user = args[8];
        }
        new GenerateAPIStats(testCase);
    }

    static {
        impersonated_user = null;
    }
}

