/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.proxy;

import ch.lambdaj.proxy.InvocationInterceptor;
import ch.lambdaj.proxy.ProxyUtil;
import ch.lambdaj.util.iterator.ResettableIterator;
import ch.lambdaj.util.iterator.ResettableIteratorOnIterable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyIterator<T>
extends InvocationInterceptor
implements Iterable<T> {
    private final ResettableIterator<? extends T> proxiedIterator;
    protected boolean enabled = true;

    protected ProxyIterator(ResettableIterator<? extends T> proxiedIterator) {
        this.proxiedIterator = proxiedIterator;
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (method.getName().equals("iterator")) {
            return this.iterator();
        }
        if (this.enabled) {
            return ProxyIterator.createProxyIterator(this.iterateOnValues(method, args), method.getReturnType());
        }
        return null;
    }

    protected ResettableIterator<Object> iterateOnValues(Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (method.getName().equals("finalize")) {
            return null;
        }
        method.setAccessible(true);
        this.proxiedIterator.reset();
        LinkedList<Object> list = new LinkedList<Object>();
        while (this.proxiedIterator.hasNext()) {
            list.add(method.invoke(this.proxiedIterator.next(), args));
        }
        return new ResettableIteratorOnIterable<Object>(list);
    }

    public static <T> T createProxyIterator(ResettableIterator<? extends T> proxiedIterator, Class<T> clazz) {
        return ProxyUtil.createIterableProxy(new ProxyIterator<T>(proxiedIterator), clazz);
    }

    public static <T> T createProxyIterator(ResettableIterator<? extends T> proxiedIterator, T firstItem) {
        Class<?> proxy = ProxyIterator.createProxyIterator(proxiedIterator, firstItem.getClass());
        proxiedIterator.reset();
        return (T)proxy;
    }

    @Override
    public Iterator<T> iterator() {
        return this.proxiedIterator;
    }
}

