/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.group;

import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupItem;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeafGroup<T>
implements Group<T> {
    private final List<T> list;
    private final Map<String, Object> headMap;
    private final Object key;

    LeafGroup(GroupItem<T> groupItem, String childrenNodeName) {
        this.key = groupItem.getGroupKey();
        this.headMap = new TreeMap<String, Object>(groupItem);
        this.list = (List)this.headMap.remove(childrenNodeName);
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public List<T> find(String key) {
        return this.list;
    }

    @Override
    public List<T> find(Object key) {
        return this.find(key.toString());
    }

    @Override
    public List<T> findAll() {
        return this.list;
    }

    @Override
    public T first() {
        return this.list.get(0);
    }

    @Override
    public Group<T> findGroup(String key) {
        return this;
    }

    @Override
    public Group<T> findGroup(Object key) {
        return this.findGroup(key.toString());
    }

    @Override
    public List<Group<T>> subgroups() {
        return new LinkedList<Group<T>>();
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>();
    }

    @Override
    public String getHeadValue(String key) {
        Object value = this.headMap.get(key);
        return value == null ? "" : value.toString();
    }

    @Override
    public Set<String> getHeads() {
        return this.headMap.keySet();
    }
}

