/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.group;

import ch.lambdaj.group.ArgumentGroupCondition;
import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupCondition;
import ch.lambdaj.group.GroupImpl;
import ch.lambdaj.group.GroupItem;
import ch.lambdaj.group.StringGroupCondition;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Groups {
    private Groups() {
    }

    public static <T> ArgumentGroupCondition<T> by(T argument) {
        return new ArgumentGroupCondition<T>(argument);
    }

    public static <T> Group<T> group(Iterable<T> iterable, Collection<? extends GroupCondition<?>> conditions) {
        return Groups.group(iterable, conditions.toArray(new GroupCondition[conditions.size()]));
    }

    public static <T> Group<T> group(Iterable<T> iterable, String ... groupers) {
        GroupCondition[] conditions = new GroupCondition[groupers.length];
        int i = 0;
        for (String grouper : groupers) {
            conditions[i++] = new StringGroupCondition(grouper);
        }
        return Groups.group(iterable, conditions);
    }

    public static <T> Group<T> group(Iterable<T> iterable, GroupCondition<?> ... conditions) {
        GroupCondition<?> condition = conditions[0];
        GroupImpl<T> group = new GroupImpl<T>(condition);
        for (T item : iterable) {
            group.addItem(item);
        }
        if (conditions.length > 1) {
            GroupCondition[] newConditions = new GroupCondition[conditions.length - 1];
            System.arraycopy(conditions, 1, newConditions, 0, newConditions.length);
            for (GroupItem groupItem : group) {
                groupItem.setChildren((GroupImpl)Groups.group(groupItem, newConditions));
            }
        }
        condition.sortGroup(group);
        return group;
    }
}

