/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.matcher;

import ch.lambdaj.function.matcher.LambdaJMatcher;
import ch.lambdaj.util.IntrospectionUtil;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasNestedPropertyWithValue<T>
extends LambdaJMatcher<T> {
    private final String propertyName;
    private final Matcher<?> value;

    public HasNestedPropertyWithValue(String propertyName, Matcher<?> value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    public boolean matches(Object item) {
        try {
            return this.value.matches(IntrospectionUtil.getPropertyValue(item, this.propertyName));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("hasProperty(");
        description.appendValue((Object)this.propertyName);
        description.appendText(", ");
        description.appendDescriptionOf(this.value);
        description.appendText(")");
    }

    @Factory
    public static <T> Matcher<T> hasNestedProperty(String propertyName, Matcher<?> value) {
        return new HasNestedPropertyWithValue<T>(propertyName, value);
    }
}

