/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.closure;

import ch.lambdaj.function.closure.AbstractClosure;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Switcher<T> {
    private final List<Case<T>> cases = new ArrayList<Case<T>>();
    private Result<T> defaultResult;

    public Switcher<T> addCase(Object object, AbstractClosure closure) {
        return this.addCase((Matcher<?>)Matchers.equalTo((Object)object), (T)closure);
    }

    public Switcher<T> addCase(Matcher<?> matcher, AbstractClosure closure) {
        this.cases.add(new Case(matcher, new ClosureResult(closure)));
        return this;
    }

    public Switcher<T> addCase(Object object, T result) {
        return this.addCase(Matchers.equalTo((Object)object), result);
    }

    public Switcher<T> addCase(Matcher<?> matcher, T result) {
        this.cases.add(new Case(matcher, new FixedResult(result)));
        return this;
    }

    public Switcher<T> setDefault(AbstractClosure closure) {
        this.defaultResult = new ClosureResult(closure);
        return this;
    }

    public Switcher<T> setDefault(T defaultResult) {
        this.defaultResult = new FixedResult(defaultResult);
        return this;
    }

    public T exec(Object match, Object ... args) {
        for (Case<T> c : this.cases) {
            if (!((Case)c).matches(match)) continue;
            return (T)((Case)c).exec(args);
        }
        return this.defaultResult != null ? (T)this.defaultResult.exec(args) : null;
    }

    public List<T> execAll(Object match, Object ... args) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Case<T> c : this.cases) {
            if (!((Case)c).matches(match)) continue;
            results.add(((Case)c).exec(args));
        }
        if (this.defaultResult != null) {
            results.add(this.defaultResult.exec(args));
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClosureResult<T>
    implements Result<T> {
        private final AbstractClosure closure;

        private ClosureResult(AbstractClosure closure) {
            this.closure = closure;
        }

        @Override
        public T exec(Object ... args) {
            return (T)this.closure.closeOne(args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixedResult<T>
    implements Result<T> {
        private final T value;

        private FixedResult(T value) {
            this.value = value;
        }

        @Override
        public T exec(Object ... args) {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Result<T> {
        public T exec(Object ... var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Case<T> {
        private final Matcher<?> matcher;
        private final Result<T> result;

        private Case(Matcher<?> matcher, Result<T> result) {
            this.matcher = matcher;
            this.result = result;
        }

        private boolean matches(Object match) {
            return this.matcher.matches(match);
        }

        private T exec(Object ... args) {
            return this.result.exec(args);
        }
    }
}

