/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.aggregate;

import ch.lambdaj.function.aggregate.InitializedPairAggregator;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sum
extends InitializedPairAggregator<Number> {
    public Sum() {
        super(0);
    }

    public Sum(Number firstItem) {
        super(firstItem);
    }

    @Override
    public Number aggregate(Number first, Number second) {
        if (second == null) {
            return first == null ? (Number)0.0 : (Number)first;
        }
        if (second instanceof Integer) {
            return this.aggregate(first, (Integer)second);
        }
        if (second instanceof Long) {
            return this.aggregate(first, (Long)second);
        }
        if (second instanceof Float) {
            return this.aggregate(first, (Float)second);
        }
        if (second instanceof Double) {
            return this.aggregate(first, (Double)second);
        }
        if (second instanceof BigInteger) {
            return this.aggregate(first, (BigInteger)second);
        }
        if (second instanceof BigDecimal) {
            return this.aggregate(first, (BigDecimal)second);
        }
        throw new RuntimeException("unable to aggregate " + first + " and " + second);
    }

    @Override
    private Integer aggregate(Number first, Integer second) {
        return (first == null ? ((Number)this.emptyItem()).intValue() : first.intValue()) + second;
    }

    @Override
    private Long aggregate(Number first, Long second) {
        return (first == null ? ((Number)this.emptyItem()).longValue() : first.longValue()) + second;
    }

    @Override
    private Float aggregate(Number first, Float second) {
        return Float.valueOf((first == null ? ((Number)this.emptyItem()).floatValue() : first.floatValue()) + second.floatValue());
    }

    @Override
    private Double aggregate(Number first, Double second) {
        return (first == null ? ((Number)this.emptyItem()).doubleValue() : first.doubleValue()) + second;
    }

    @Override
    private BigInteger aggregate(Number first, BigInteger second) {
        return (first == null || !(first instanceof BigInteger) ? BigInteger.ZERO : (BigInteger)first).add(second);
    }

    @Override
    private BigDecimal aggregate(Number first, BigDecimal second) {
        return (first == null || !(first instanceof BigDecimal) ? BigDecimal.ZERO : (BigDecimal)first).add(second);
    }
}

