/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.aggregate;

import ch.lambdaj.function.aggregate.Aggregator;
import ch.lambdaj.proxy.ProxyIterator;
import ch.lambdaj.proxy.ProxyUtil;
import ch.lambdaj.util.iterator.ResettableIterator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyAggregator<T, A>
extends ProxyIterator<T> {
    private final Aggregator<A> aggregator;

    protected ProxyAggregator(ResettableIterator<T> proxiedIterator, Aggregator<A> aggregator) {
        super(proxiedIterator);
        this.aggregator = aggregator;
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (this.enabled) {
            return this.normalizeResult(method.getReturnType(), this.aggregator.aggregate(this.iterateOnValues(method, args)));
        }
        return null;
    }

    private Object normalizeResult(Class<?> expectedResultType, Object result) {
        if (result == null) {
            return this.normalizeNullResult(expectedResultType, result);
        }
        if (expectedResultType.isInstance(result)) {
            return result;
        }
        if (expectedResultType == BigInteger.class) {
            return new BigInteger(result.toString());
        }
        if (expectedResultType == BigDecimal.class) {
            return new BigDecimal(result.toString());
        }
        return result;
    }

    private Object normalizeNullResult(Class<?> expectedResultType, Object result) {
        if (expectedResultType == BigInteger.class) {
            return BigInteger.ZERO;
        }
        if (expectedResultType == BigDecimal.class) {
            return BigDecimal.ZERO;
        }
        return result;
    }

    public static <T, A> T createProxyAggregator(ResettableIterator<T> proxiedIterator, Aggregator<A> aggregator, Class<?> clazz) {
        return (T)ProxyUtil.createIterableProxy(new ProxyAggregator<T, A>(proxiedIterator, aggregator), clazz);
    }
}

