/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.aggregate;

import ch.lambdaj.function.aggregate.Sum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Avg
extends Sum {
    int itemsCounter = 0;

    @Override
    public Number aggregate(Iterator<? extends Number> iterator) {
        return this.divide(super.aggregate(iterator), this.itemsCounter);
    }

    @Override
    public Number aggregate(Number first, Number second) {
        ++this.itemsCounter;
        return super.aggregate(first, second);
    }

    private Number divide(Number total, int count) {
        if (count < 2) {
            return total;
        }
        if (total instanceof Integer) {
            return total.intValue() / count;
        }
        if (total instanceof Long) {
            return total.longValue() / (long)count;
        }
        if (total instanceof Float) {
            return Float.valueOf(total.floatValue() / (float)count);
        }
        if (total instanceof Double) {
            return total.doubleValue() / (double)count;
        }
        if (total instanceof BigInteger) {
            return ((BigInteger)total).divide(BigInteger.valueOf(count));
        }
        if (total instanceof BigDecimal) {
            return ((BigDecimal)total).divide(new BigDecimal(count));
        }
        throw new RuntimeException("Unknown number type");
    }
}

