/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.collection;

import ch.lambdaj.collection.LambdaCollection;
import ch.lambdaj.collection.LambdaIterable;
import ch.lambdaj.collection.LambdaIterator;
import ch.lambdaj.collection.LambdaList;
import ch.lambdaj.collection.LambdaMap;
import ch.lambdaj.collection.LambdaSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LambdaCollections {
    private LambdaCollections() {
    }

    public static <T> LambdaIterator<T> with(Iterator<? extends T> iterator) {
        return new LambdaIterator<T>(iterator);
    }

    public static <T> LambdaList<T> with(List<? extends T> list) {
        return new LambdaList<T>(list);
    }

    public static <T> LambdaList<T> with(T ... array) {
        return new LambdaList<T>(new ArrayList<T>(Arrays.asList(array)));
    }

    public static <T> LambdaCollection<T> with(Collection<? extends T> collection) {
        return new LambdaCollection<T>(collection);
    }

    public static <T> LambdaIterable<T> with(Iterable<? extends T> iterable) {
        return new LambdaIterable<T>(iterable);
    }

    public static <K, V> LambdaMap<K, V> with(Map<? extends K, ? extends V> map) {
        return new LambdaMap<K, V>(map);
    }

    public static <T> LambdaSet<T> with(Set<? extends T> set) {
        return new LambdaSet<T>(set);
    }
}

