/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.collection;

import ch.lambdaj.collection.LambdaIterable;
import ch.lambdaj.function.convert.Converter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaCollection<T>
extends LambdaIterable<T>
implements Collection<T>,
Cloneable,
Serializable {
    LambdaCollection(Collection<? extends T> inner) {
        super(inner);
    }

    private Collection<T> innerCollection() {
        return (Collection)this.innerIterable;
    }

    @Override
    public LambdaCollection<T> retain(Matcher<?> matcher) {
        this.doRetain(matcher);
        return this;
    }

    @Override
    public LambdaCollection<T> remove(Matcher<?> matcher) {
        this.doRemove(matcher);
        return this;
    }

    @Override
    public LambdaCollection<T> sort(Object argument) {
        this.doSort(argument);
        return this;
    }

    @Override
    public <V> LambdaCollection<V> convert(Converter<T, V> converter) {
        return new LambdaCollection<V>(this.doConvert(converter));
    }

    @Override
    public <V> LambdaCollection<V> extract(V argument) {
        return new LambdaCollection<V>(this.doExtract(argument));
    }

    @Override
    public LambdaCollection<T> replace(Matcher<?> matcher, T replacer) {
        this.doReplace(matcher, replacer);
        return this;
    }

    @Override
    public LambdaCollection<T> distinct(Object argument) {
        this.doDistinct(argument);
        return this;
    }

    @Override
    public <V> LambdaCollection<V> project(Class<V> targetClass, Object ... arguments) {
        return new LambdaCollection<V>(this.doProject(targetClass, arguments));
    }

    public LambdaCollection<T> append(T ... list) {
        this.addAll((Collection<? extends T>)Arrays.asList(list));
        return this;
    }

    public T[] toArray(Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, this.innerCollection().size());
        int i = 0;
        for (T item : this.innerCollection()) {
            array[i++] = item;
        }
        return array;
    }

    @Override
    public boolean add(T e) {
        return this.innerCollection().add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.innerCollection().addAll(c);
    }

    @Override
    public void clear() {
        this.innerCollection().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.innerCollection().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.innerCollection().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.innerCollection().isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.innerCollection().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.innerCollection().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.innerCollection().retainAll(c);
    }

    @Override
    public int size() {
        return this.innerCollection().size();
    }

    @Override
    public Object[] toArray() {
        return this.innerCollection().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.innerCollection().toArray(a);
    }

    @Override
    public LambdaCollection<T> clone() {
        return new LambdaCollection<T>((Collection)this.innerClone(new ArrayList()));
    }
}

