/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj;

import ch.lambdaj.function.aggregate.Aggregator;
import ch.lambdaj.function.aggregate.Avg;
import ch.lambdaj.function.aggregate.Concat;
import ch.lambdaj.function.aggregate.Max;
import ch.lambdaj.function.aggregate.MaxOnArgument;
import ch.lambdaj.function.aggregate.Min;
import ch.lambdaj.function.aggregate.MinOnArgument;
import ch.lambdaj.function.aggregate.ProxyAggregator;
import ch.lambdaj.function.aggregate.Sum;
import ch.lambdaj.function.aggregate.SumDouble;
import ch.lambdaj.function.aggregate.SumInteger;
import ch.lambdaj.function.aggregate.SumLong;
import ch.lambdaj.function.argument.Argument;
import ch.lambdaj.function.argument.ArgumentsFactory;
import ch.lambdaj.function.closure.Closure;
import ch.lambdaj.function.closure.Closure1;
import ch.lambdaj.function.closure.Closure2;
import ch.lambdaj.function.closure.Closure3;
import ch.lambdaj.function.closure.Closure4;
import ch.lambdaj.function.closure.ClosureResult;
import ch.lambdaj.function.closure.ClosuresFactory;
import ch.lambdaj.function.closure.DelayedClosure;
import ch.lambdaj.function.compare.ArgumentComparator;
import ch.lambdaj.function.compare.PropertyComparator;
import ch.lambdaj.function.convert.AliasedArgumentConverter;
import ch.lambdaj.function.convert.ArgumentConverter;
import ch.lambdaj.function.convert.ConstructorArgumentConverter;
import ch.lambdaj.function.convert.Converter;
import ch.lambdaj.function.convert.ConverterIterator;
import ch.lambdaj.function.convert.DefaultStringConverter;
import ch.lambdaj.function.convert.ProjectConverter;
import ch.lambdaj.function.convert.PropertyExtractor;
import ch.lambdaj.function.matcher.HasArgumentWithValue;
import ch.lambdaj.group.ArgumentGroupCondition;
import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupCondition;
import ch.lambdaj.group.Groups;
import ch.lambdaj.proxy.ProxyIterator;
import ch.lambdaj.util.NotUniqueItemException;
import ch.lambdaj.util.iterator.IteratorFactory;
import ch.lambdaj.util.iterator.MatchingIterator;
import ch.lambdaj.util.iterator.ResettableIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Lambda {
    private static final Sum SUM = new Sum();
    private static final Min MIN = new Min();
    private static final Max MAX = new Max();
    private static final Concat CONCAT = new Concat();

    private Lambda() {
    }

    public static <T> T on(Class<T> clazz) {
        return ArgumentsFactory.createArgument(clazz);
    }

    public static <T> Argument<T> argument(T argumentPlaceholder) {
        return ArgumentsFactory.actualArgument(argumentPlaceholder);
    }

    public static <T> T forEach(Iterable<? extends T> iterable) {
        ResettableIterator<?> resettableIterator = IteratorFactory.asResettableIterator(iterable);
        if (!resettableIterator.hasNext()) {
            throw new IllegalArgumentException("forEach() is unable to introspect on an empty iterator. Use the overloaded method accepting a class instead");
        }
        return (T)ProxyIterator.createProxyIterator(resettableIterator, resettableIterator.next());
    }

    public static <T> T forEach(Iterator<? extends T> iterator) {
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("forEach() is unable to introspect on an empty iterator. Use the overloaded method accepting a class instead");
        }
        ResettableIterator<?> resettableIterator = IteratorFactory.asResettableIterator(iterator);
        return (T)ProxyIterator.createProxyIterator(resettableIterator, resettableIterator.next());
    }

    public static <T> T forEach(Iterable<? extends T> iterable, Class<T> clazz) {
        return (T)ProxyIterator.createProxyIterator(IteratorFactory.asResettableIterator(iterable), clazz);
    }

    public static <T> T forEach(Iterator<? extends T> iterator, Class<T> clazz) {
        return (T)ProxyIterator.createProxyIterator(IteratorFactory.asResettableIterator(iterator), clazz);
    }

    public static <T> T forEach(T ... array) {
        return (T)Lambda.forEach(array[0].getClass(), array);
    }

    public static <T> T forEach(Class<T> clazz, T ... array) {
        return (T)ProxyIterator.createProxyIterator(IteratorFactory.asResettableIterator(array), clazz);
    }

    public static <T> List<T> flatten(Object iterable) {
        return IteratorFactory.flattenIterator(iterable);
    }

    public static <T> List<? extends T> collect(Object iterable) {
        LinkedList<Object> collected = new LinkedList<Object>();
        Iterator<?> i = IteratorFactory.asIterator(iterable);
        while (i.hasNext()) {
            Object item = i.next();
            if (item instanceof Iterable) {
                collected.addAll(Lambda.collect(item));
                continue;
            }
            if (item instanceof Map) {
                collected.addAll(Lambda.collect(((Map)item).values()));
                continue;
            }
            collected.add(item);
        }
        return collected;
    }

    public static <T> List<T> collect(Object iterable, T argument) {
        return Lambda.collect(Lambda.convert(iterable, new ArgumentConverter(argument)));
    }

    public static <T> List<T> sort(Object iterable, Object argument) {
        return Lambda.sort(iterable, argument, null);
    }

    public static <T, A> List<T> sort(Object iterable, A argument, Comparator<A> comparator) {
        LinkedList sorted = new LinkedList();
        Iterator<?> i = IteratorFactory.asIterator(iterable);
        while (i.hasNext()) {
            sorted.add(i.next());
        }
        Collections.sort(sorted, new ArgumentComparator(argument, comparator));
        return sorted;
    }

    public static <T> Map<T, Integer> count(Object iterable) {
        HashMap countMap = new HashMap();
        Iterator<?> i = IteratorFactory.asIterator(iterable);
        while (i.hasNext()) {
            Object item;
            Integer counter = (Integer)countMap.get(item = i.next());
            countMap.put(item, counter == null ? 1 : counter + 1);
        }
        return countMap;
    }

    public static <A> Map<A, Integer> count(Object iterable, A argument) {
        return Lambda.count(Lambda.extract(iterable, argument));
    }

    public static <T> List<T> filter(Matcher<?> matcher, Iterable<T> iterable) {
        return Lambda.select(iterable, matcher);
    }

    public static <T> List<T> filter(Matcher<?> matcher, T ... array) {
        return Lambda.select(array, matcher);
    }

    public static <T> List<T> select(Iterator<T> iterator, Matcher<?> matcher) {
        LinkedList<T> collected = new LinkedList<T>();
        if (iterator == null) {
            return collected;
        }
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!matcher.matches(item)) continue;
            collected.add(item);
        }
        return collected;
    }

    public static <T> List<T> select(Iterable<T> iterable, Matcher<?> matcher) {
        if (iterable == null) {
            return new LinkedList();
        }
        return Lambda.select(iterable.iterator(), matcher);
    }

    public static <T> List<T> select(Object iterable, Matcher<?> matcher) {
        return Lambda.select(IteratorFactory.asIterator(iterable), matcher);
    }

    public static <T> Iterator<T> selectIterator(Object iterable, Matcher<?> matcher) {
        return new MatchingIterator(IteratorFactory.asIterator(iterable), matcher);
    }

    public static <T> T selectUnique(Object iterable, Matcher<?> matcher) {
        MatchingIterator iterator = new MatchingIterator(IteratorFactory.asIterator(iterable), matcher);
        if (!iterator.hasNext()) {
            return null;
        }
        Object unique = iterator.next();
        if (iterator.hasNext()) {
            throw new NotUniqueItemException();
        }
        return (T)unique;
    }

    public static boolean exists(Object iterable, Matcher<?> matcher) {
        return Lambda.selectFirst(iterable, matcher) != null;
    }

    public static <T> T selectFirst(Object iterable, Matcher<?> matcher) {
        Iterator<?> iterator = IteratorFactory.asIterator(iterable);
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (!matcher.matches(item)) continue;
            return (T)item;
        }
        return null;
    }

    public static <T> Collection<T> selectDistinct(Iterable<T> iterable) {
        return Lambda.selectDistinct(iterable, (Comparator)null);
    }

    public static <T> Collection<T> selectDistinct(Object iterable) {
        return Lambda.selectDistinct(iterable, (Comparator)null);
    }

    public static <T> Collection<T> selectDistinct(Object iterable, String propertyName) {
        return Lambda.selectDistinct(iterable, new PropertyComparator(propertyName));
    }

    public static <T, A> Collection<T> selectDistinctArgument(Object iterable, A argument) {
        return Lambda.selectDistinct(iterable, new ArgumentComparator(argument));
    }

    public static <T> Collection<T> selectDistinct(Object iterable, Comparator<T> comparator) {
        AbstractSet collected = comparator == null ? new HashSet() : new TreeSet<T>(comparator);
        Iterator<?> i = IteratorFactory.asIterator(iterable);
        while (i.hasNext()) {
            collected.add(i.next());
        }
        return collected;
    }

    public static <T, A> T selectMin(Object iterable, A argument) {
        return Lambda.aggregate(iterable, new MinOnArgument(argument));
    }

    public static <T, A> T selectMax(Object iterable, A argument) {
        return Lambda.aggregate(iterable, new MaxOnArgument(argument));
    }

    private static Aggregator<? extends Number> getSumAggregator(Object object) {
        if (object instanceof Integer) {
            return new SumInteger((Integer)object);
        }
        if (object instanceof Double) {
            return new SumDouble((Double)object);
        }
        if (object instanceof Long) {
            return new SumLong((Long)object);
        }
        return new Sum((Number)object);
    }

    public static <T> T aggregate(Object iterable, Aggregator<T> aggregator) {
        return aggregator.aggregate(IteratorFactory.asIterator(iterable));
    }

    public static <T, A> T aggregate(Object iterable, Aggregator<T> aggregator, A argument) {
        return Lambda.aggregate(Lambda.convertIterator(iterable, new ArgumentConverter(argument)), aggregator);
    }

    public static <T, A> T aggregateFrom(Iterable<T> iterable, Aggregator<A> aggregator) {
        return Lambda.aggregateFrom(iterable, IteratorFactory.discoverGenericType(iterable), aggregator);
    }

    public static <T, A> T aggregateFrom(Iterable<T> iterable, Class<?> clazz, Aggregator<A> aggregator) {
        return (T)ProxyAggregator.createProxyAggregator(IteratorFactory.asResettableIterator(iterable), aggregator, clazz);
    }

    public static Number sum(Object iterable) {
        return Lambda.typedSum(iterable, Double.class);
    }

    public static <T> T sum(Object iterable, T argument) {
        return (T)Lambda.typedSum(Lambda.convertIterator(iterable, new ArgumentConverter(argument)), argument.getClass());
    }

    private static Number typedSum(Object iterable, Class<?> numberClass) {
        if (iterable instanceof Number) {
            return (Number)iterable;
        }
        Iterator<?> iterator = IteratorFactory.asIterator(iterable);
        return iterator.hasNext() ? (Number)Lambda.aggregate(iterator, Lambda.getSumAggregator(iterator.next())) : (Number)Lambda.typedZero(numberClass);
    }

    private static Number typedZero(Class<?> numberClass) {
        if (numberClass == Double.class) {
            return 0.0;
        }
        if (numberClass == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (BigInteger.class.isAssignableFrom(numberClass)) {
            return BigInteger.ZERO;
        }
        if (BigDecimal.class.isAssignableFrom(numberClass)) {
            return BigDecimal.ZERO;
        }
        return 0;
    }

    public static <T> T sumFrom(Iterable<T> iterable) {
        return Lambda.aggregateFrom(iterable, SUM);
    }

    public static <T> T sumFrom(Iterable<T> iterable, Class<?> clazz) {
        return Lambda.aggregateFrom(iterable, clazz, SUM);
    }

    public static Number avg(Object iterable) {
        return Lambda.typedAvg(iterable, Double.class);
    }

    public static <T> T avg(Object iterable, T argument) {
        return (T)Lambda.typedAvg(Lambda.convertIterator(iterable, new ArgumentConverter(argument)), argument.getClass());
    }

    private static Number typedAvg(Object iterable, Class<?> numberClass) {
        if (iterable instanceof Number) {
            return (Number)iterable;
        }
        Iterator<?> iterator = IteratorFactory.asIterator(iterable);
        return iterator.hasNext() ? (Number)Lambda.aggregate(iterator, new Avg()) : (Number)Lambda.typedZero(numberClass);
    }

    public static <T> T avgFrom(Iterable<T> iterable) {
        return Lambda.aggregateFrom(iterable, new Avg());
    }

    public static <T> T avgFrom(Iterable<T> iterable, Class<?> clazz) {
        return Lambda.aggregateFrom(iterable, clazz, new Avg());
    }

    public static <T> T min(Object iterable) {
        return Lambda.aggregate(iterable, MIN);
    }

    public static <T> T min(Object iterable, T argument) {
        return Lambda.aggregate(iterable, MIN, argument);
    }

    public static <T> T minFrom(Iterable<T> iterable) {
        return Lambda.aggregateFrom(iterable, MIN);
    }

    public static <T> T minFrom(Iterable<T> iterable, Class<?> clazz) {
        return Lambda.aggregateFrom(iterable, clazz, MIN);
    }

    public static <T> T max(Object iterable) {
        return Lambda.aggregate(iterable, MAX);
    }

    public static <T> T max(Object iterable, T argument) {
        return Lambda.aggregate(iterable, MAX, argument);
    }

    public static <T> T maxFrom(Iterable<T> iterable) {
        return Lambda.aggregateFrom(iterable, MAX);
    }

    public static <T> T maxFrom(Iterable<T> iterable, Class<?> clazz) {
        return Lambda.aggregateFrom(iterable, clazz, MAX);
    }

    public static <T> T joinFrom(Iterable<T> iterable) {
        return Lambda.aggregateFrom(iterable, CONCAT);
    }

    public static <T> T joinFrom(Iterable<T> iterable, String separator) {
        return Lambda.aggregateFrom(iterable, new Concat(separator));
    }

    public static <T> T joinFrom(Iterable<T> iterable, Class<?> clazz) {
        return Lambda.aggregateFrom(iterable, clazz, CONCAT);
    }

    public static <T> T joinFrom(Iterable<T> iterable, Class<?> clazz, String separator) {
        return Lambda.aggregateFrom(iterable, clazz, new Concat(separator));
    }

    public static String join(Object iterable) {
        return Lambda.join(iterable, ", ");
    }

    public static String join(Object iterable, String separator) {
        if (iterable == null) {
            return "";
        }
        try {
            return (String)Lambda.aggregate(iterable, new Concat(separator));
        }
        catch (IllegalArgumentException e) {
            return iterable.toString();
        }
    }

    public static <F, T> List<T> convert(Object iterable, Converter<F, T> converter) {
        LinkedList<T> collected = new LinkedList<T>();
        Iterator<T> i = Lambda.convertIterator(iterable, converter);
        while (i.hasNext()) {
            collected.add(i.next());
        }
        return collected;
    }

    public static <F, T> Iterator<T> convertIterator(Object iterable, Converter<F, T> converter) {
        return new ConverterIterator<F, T>(converter, IteratorFactory.asIterator(iterable));
    }

    public static <K, F, T> Map<K, T> convertMap(Map<K, F> map, Converter<F, T> converter) {
        HashMap<K, T> converted = new HashMap<K, T>();
        for (Map.Entry<K, F> entry : map.entrySet()) {
            converted.put(entry.getKey(), converter.convert(entry.getValue()));
        }
        return converted;
    }

    public static <K, F, T> Map<K, T> convertMap(Map<K, F> map, T argument) {
        return Lambda.convertMap(map, new ArgumentConverter(argument));
    }

    public static <F, T> List<T> extract(Object iterable, T argument) {
        return Lambda.convert(iterable, new ArgumentConverter(argument));
    }

    public static <F, T> Iterator<T> extractIterator(Object iterable, T argument) {
        return Lambda.convertIterator(iterable, new ArgumentConverter(argument));
    }

    public static List<String> extractString(Object iterable) {
        return Lambda.convert(iterable, new DefaultStringConverter());
    }

    public static <F, T> List<T> extractProperty(Object iterable, String propertyName) {
        return Lambda.convert(iterable, new PropertyExtractor(propertyName));
    }

    public static <F, T> Map<T, F> map(Object iterable, Converter<F, T> converter) {
        HashMap map = new HashMap();
        Iterator<?> i = IteratorFactory.asIterator(iterable);
        while (i.hasNext()) {
            Object item = i.next();
            map.put(converter.convert(item), item);
        }
        return map;
    }

    public static <F, T> Map<T, F> map(Object iterable, Matcher<?> matcher, Converter<F, T> converter) {
        HashMap map = new HashMap();
        Iterator<?> i = IteratorFactory.asIterator(iterable);
        while (i.hasNext()) {
            Object item = i.next();
            if (!matcher.matches(item)) continue;
            map.put(converter.convert(item), item);
        }
        return map;
    }

    public static <F, T> Map<T, F> index(Object iterable, T argument) {
        return Lambda.map(iterable, new ArgumentConverter(argument));
    }

    public static <F, T> Map<T, F> index(Object iterable, Matcher<F> matcher, T argument) {
        return Lambda.map(iterable, matcher, new ArgumentConverter(argument));
    }

    public static <T> List<T> project(Object iterable, Class<T> targetClass, Object ... arguments) {
        return Lambda.convert(iterable, new ConstructorArgumentConverter(targetClass, arguments));
    }

    public static <F> List<Map<String, Object>> project(Object iterable, Converter<F, Map.Entry<String, Object>> ... projectors) {
        return Lambda.convert(iterable, new ProjectConverter<F>(projectors));
    }

    public static <F> Converter<F, Map.Entry<String, Object>> as(Object argument) {
        return new AliasedArgumentConverter(argument);
    }

    public static <F> Converter<F, Map.Entry<String, Object>> as(String alias, Object argument) {
        return new AliasedArgumentConverter(alias, argument);
    }

    public static <T> HasArgumentWithValue<T, Boolean> having(Boolean argument) {
        return HasArgumentWithValue.havingValue(argument);
    }

    public static <T, A> HasArgumentWithValue<T, A> having(A argument, Matcher<?> matcher) {
        return HasArgumentWithValue.havingValue(argument, matcher);
    }

    public static <T> ArgumentGroupCondition<T> by(T argument) {
        return Groups.by(argument);
    }

    public static <T> Group<T> group(Iterable<T> iterable, Collection<? extends GroupCondition<?>> conditions) {
        return Groups.group(iterable, conditions);
    }

    public static <T> Group<T> group(Iterable<T> iterable, String ... groupers) {
        return Groups.group(iterable, groupers);
    }

    public static <T> Group<T> group(Iterable<T> iterable, GroupCondition<?> ... conditions) {
        return Groups.group(iterable, conditions);
    }

    public static <T> T of(T closed) {
        return Lambda.of(closed, closed.getClass());
    }

    public static <T> T of(Class<T> closedClass) {
        return ClosuresFactory.bindClosure(closedClass, closedClass);
    }

    public static <T> T of(T closed, Class<T> closedClass) {
        return ClosuresFactory.bindClosure(closed, closedClass);
    }

    public static <T> T var(Class<T> clazz) {
        return ClosuresFactory.createClosureVarPlaceholder(clazz);
    }

    public static Closure closure() {
        return ClosuresFactory.createClosure();
    }

    public static <A> Closure1<A> closure(Class<A> type1) {
        return ClosuresFactory.createClosure(type1);
    }

    public static <A, B> Closure2<A, B> closure(Class<A> type1, Class<B> type2) {
        return ClosuresFactory.createClosure(type1, type2);
    }

    public static <A, B, C> Closure3<A, B, C> closure(Class<A> type1, Class<B> type2, Class<C> type3) {
        return ClosuresFactory.createClosure(type1, type2, type3);
    }

    public static <A, B, C, D> Closure4<A, B, C, D> closure(Class<A> type1, Class<B> type2, Class<C> type3, Class<D> type4) {
        return ClosuresFactory.createClosure(type1, type2, type3, type4);
    }

    public static <T> ClosureResult<T> delayedClosure(DelayedClosure<T> delayedClosure) {
        return delayedClosure.getClosureResult();
    }
}

