/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning.commons.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static Logger logger = LoggerFactory.getLogger(JSONUtil.class);

    public static <T> T toJavaObject(Object obj, Class<T> cls) {
        if (obj == null) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (obj instanceof String) {
                return (T)objectMapper.readValue(obj.toString(), cls);
            }
            return (T)objectMapper.readValue(objectMapper.writeValueAsString(obj), cls);
        }
        catch (Exception e) {
            logger.error("An exception occurs when converting an object to another Java object through jackson", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> toMap(Object obj) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        Map map = JSONUtil.toJavaObject(obj, HashMap.class);
        if (map == null) {
            return new HashMap<String, Object>();
        }
        return map;
    }

    public static String toJSONString(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (obj instanceof String) {
                return obj.toString();
            }
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error("Convert object to JSON string exception", (Throwable)e);
            return "";
        }
    }
}

