/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning.chain.impl;

import com.blockchain.scanning.biz.thread.EventQueue;
import com.blockchain.scanning.biz.thread.RetryStrategyQueue;
import com.blockchain.scanning.biz.thread.model.EventModel;
import com.blockchain.scanning.chain.ChainScanner;
import com.blockchain.scanning.chain.model.TransactionModel;
import com.blockchain.scanning.chain.model.tron.TronBlockModel;
import com.blockchain.scanning.chain.model.tron.TronTransactionModel;
import com.blockchain.scanning.commons.config.BlockChainConfig;
import com.blockchain.scanning.commons.constant.TronConstants;
import com.blockchain.scanning.commons.enums.BlockEnums;
import com.blockchain.scanning.commons.util.JSONUtil;
import com.blockchain.scanning.commons.util.StringUtil;
import com.blockchain.scanning.commons.util.okhttp.OkHttpUtil;
import com.blockchain.scanning.monitor.TronMonitorEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TronChainScanner
extends ChainScanner {
    private Logger logger = LoggerFactory.getLogger(TronChainScanner.class);
    private List<String> tronRpcUrls;
    private List<TronMonitorEvent> tronMonitorEvents;

    @Override
    public void init(BlockChainConfig blockChainConfig, EventQueue eventQueue, RetryStrategyQueue retryStrategyQueue) {
        super.init(blockChainConfig, eventQueue, retryStrategyQueue);
        this.tronRpcUrls = blockChainConfig.getTronRpcUrls();
        this.tronMonitorEvents = blockChainConfig.getEventConfig().getTronMonitorEvents();
    }

    @Override
    public void scan(BigInteger beginBlockNumber) {
        try {
            String url = this.tronRpcUrls.get(this.getNextIndex(this.tronRpcUrls.size()));
            BigInteger lastBlockNumber = this.getBlock(url).getTronBlockHeaderModel().getTronRawDataModel().getNumber();
            if (beginBlockNumber.compareTo(BlockEnums.LAST_BLOCK_NUMBER.getValue()) == 0) {
                beginBlockNumber = lastBlockNumber;
            }
            if (beginBlockNumber.compareTo(lastBlockNumber) > 0) {
                this.logger.info("[TRON], The block height on the chain has fallen behind the block scanning progress, pause scanning in progress ...... , scan progress [{}], latest block height on chain:[{}]", (Object)beginBlockNumber, (Object)lastBlockNumber);
                return;
            }
            TronBlockModel tronBlockModel = this.getBlockByNum(url, beginBlockNumber);
            if (tronBlockModel == null) {
                this.logger.info("[TRON], Block height [{}] does not exist", (Object)beginBlockNumber);
                if (lastBlockNumber.compareTo(beginBlockNumber) > 0) {
                    this.blockChainConfig.setBeginBlockNumber(beginBlockNumber.add(BigInteger.ONE));
                    this.addRetry(beginBlockNumber);
                }
                return;
            }
            List<TronTransactionModel> tronTransactionList = tronBlockModel.getTransactions();
            if (tronTransactionList == null || tronTransactionList.size() < 1) {
                this.logger.info("[TRON], No transactions were scanned on block height [{}]", (Object)beginBlockNumber);
                if (lastBlockNumber.compareTo(beginBlockNumber) > 0) {
                    this.blockChainConfig.setBeginBlockNumber(beginBlockNumber.add(BigInteger.ONE));
                    this.addRetry(beginBlockNumber);
                }
                return;
            }
            ArrayList<TransactionModel> transactionList = new ArrayList<TransactionModel>();
            for (TronTransactionModel transaction : tronTransactionList) {
                if (transaction == null) continue;
                transaction.setBlockID(tronBlockModel.getBlockID());
                transaction.setTronBlockHeaderModel(tronBlockModel.getTronBlockHeaderModel());
                transactionList.add(TransactionModel.builder().setTronTransactionModel(transaction));
            }
            this.eventQueue.add(EventModel.builder().setCurrentBlockHeight(beginBlockNumber).setTransactionModels(transactionList));
            this.blockChainConfig.setBeginBlockNumber(beginBlockNumber.add(BigInteger.ONE));
        }
        catch (Exception e) {
            this.logger.error("[TRON], An exception occurred while scanning, block height:[{}]", (Object)beginBlockNumber, (Object)e);
        }
    }

    @Override
    public void call(TransactionModel transactionModel) {
        for (TronMonitorEvent tronMonitorEvent : this.tronMonitorEvents) {
            try {
                tronMonitorEvent.call(transactionModel);
            }
            catch (Exception e) {
                this.logger.error("[ETH], An exception occurred in the call method of the listener", (Throwable)e);
            }
        }
    }

    private TronBlockModel getBlock(String url) throws Exception {
        String result = OkHttpUtil.postJson(url + "/getblock", TronConstants.GET_NOW_BLOCK_PARAMETER);
        if (StringUtil.isEmpty(result)) {
            throw new Exception("An exception occurred when obtaining the latest block, result: null");
        }
        return JSONUtil.toJavaObject(result, TronBlockModel.class);
    }

    private TronBlockModel getBlockByNum(String url, BigInteger blockNumber) throws Exception {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("num", blockNumber);
        String result = OkHttpUtil.postJson(url + "/getblockbynum", parameter);
        if (StringUtil.isEmpty(result)) {
            throw new Exception("An exception occurred when querying blocks based on block height, result: null");
        }
        return JSONUtil.toJavaObject(result, TronBlockModel.class);
    }
}

