/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning.biz.thread;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EventThreadPool {
    private static ThreadPoolExecutor threadPoolExecutor;

    public static void init(int corePoolSize) {
        if (threadPoolExecutor == null) {
            threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, corePoolSize * 2, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(corePoolSize * 10));
        }
    }

    public static void submit(Runnable runnable) throws Exception {
        if (threadPoolExecutor == null) {
            throw new Exception("To perform scanning tasks, you need to initialize the thread pool first, you can call the EventThreadPool.init(1) method to initialize");
        }
        threadPoolExecutor.submit(runnable);
    }

    public static void shutdown() {
        if (threadPoolExecutor != null) {
            threadPoolExecutor.shutdown();
        }
    }
}

