/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hppc.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public abstract class ContainerSerializerBase<T>
extends ContainerSerializer<T> {
    private static final long serialVersionUID = 1L;
    protected final String _schemeElementType;

    protected ContainerSerializerBase(Class<T> type, String schemaElementType) {
        super(type);
        this._schemeElementType = schemaElementType;
    }

    protected ContainerSerializerBase(JavaType type, String schemaElementType) {
        super(type);
        this._schemeElementType = schemaElementType;
    }

    protected ContainerSerializerBase(ContainerSerializerBase<?> src) {
        super(src._handledType, true);
        this._schemeElementType = src._schemeElementType;
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        o.set("items", (JsonNode)this.createSchemaNode(this._schemeElementType));
        return o;
    }

    public abstract boolean isEmpty(SerializerProvider var1, T var2);

    public JsonSerializer<?> getContentSerializer() {
        return null;
    }

    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        throw new UnsupportedOperationException();
    }

    public JavaType getContentType() {
        return null;
    }

    public abstract void acceptJsonFormatVisitor(JsonFormatVisitorWrapper var1, JavaType var2) throws JsonMappingException;

    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        this.serializeContents(value, jgen, provider);
        jgen.writeEndArray();
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    public void serializeWithType(T value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForArray(value, jgen);
        this.serializeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForArray(value, jgen);
    }

    protected JsonSerializer<?> getSerializer(JavaType type) {
        if (this._handledType.isAssignableFrom(type.getRawClass())) {
            return this;
        }
        return null;
    }
}

