/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.persistence.tools.eclipselink;

import com.ethlo.persistence.tools.eclipselink.PersistenceXmlHelper;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.persistence.Converter;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;

@Mojo(requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES, name="weave", requiresProject=true)
public class EclipselinkStaticWeaveMojo
extends AbstractMojo {
    @Parameter
    private String basePackage;
    @Parameter
    private String[] basePackages;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File source;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File target;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File persistenceInfoLocation;
    @Parameter(defaultValue="WARNING", property="logLevel")
    private String logLevel;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.setLogLevel(this.logLevel);
        URLClassLoader classLoader = new URLClassLoader(this.getClassPath(), Thread.currentThread().getContextClassLoader());
        try {
            this.processWeaving(classLoader);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        this.getLog().info((CharSequence)"Eclipselink weaving completed");
    }

    private void processWeaving(ClassLoader classLoader) throws MojoExecutionException, MojoFailureException {
        if (!this.source.exists()) {
            throw new MojoExecutionException("Source directory " + this.source + " does not exist");
        }
        try {
            Object[] allBasePackages = this.getBasePackages();
            if (allBasePackages.length > 0) {
                this.getLog().info((CharSequence)("Only entities from base packages '" + StringUtils.arrayToDelimitedString((Object[])allBasePackages, (String)", ") + "' will be included in persistence.xml"));
            }
            Object[] classPath = this.getClassPath();
            this.getLog().debug((CharSequence)("Scanning class-path: " + Arrays.toString(classPath)));
            FastClasspathScanner scanner = new FastClasspathScanner((String[])allBasePackages).overrideClasspath(classPath);
            ScanResult scanResult = scanner.scan();
            Set<String> entityClasses = this.findEntities(scanResult);
            this.getLog().info((CharSequence)("Entities found : " + entityClasses.size()));
            this.processPersistenceXml(classLoader, entityClasses);
            this.getLog().info((CharSequence)("Source classes dir: " + this.source));
            this.getLog().info((CharSequence)("Target classes dir: " + this.target));
            StaticWeaveProcessor weaveProcessor = new StaticWeaveProcessor(this.source, this.target);
            weaveProcessor.setPersistenceInfo(this.persistenceInfoLocation);
            weaveProcessor.setClassLoader(classLoader);
            weaveProcessor.setLog((Writer)new PrintWriter(System.out));
            weaveProcessor.setLogLevel(this.getLogLevel());
            weaveProcessor.performWeaving();
        }
        catch (IOException | URISyntaxException e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private void processPersistenceXml(ClassLoader classLoader, Set<String> entityClasses) {
        File targetFile = new File(this.persistenceInfoLocation + "/META-INF/persistence.xml");
        this.getLog().info((CharSequence)("persistence.xml location: " + targetFile));
        String name = this.project.getArtifactId();
        Document doc = targetFile.exists() ? PersistenceXmlHelper.parseXml(targetFile) : PersistenceXmlHelper.createXml(name);
        this.checkExisting(targetFile, classLoader, doc, entityClasses);
        PersistenceXmlHelper.appendClasses(doc, entityClasses);
        PersistenceXmlHelper.outputXml(doc, targetFile);
    }

    private void checkExisting(File targetFile, ClassLoader classLoader, Document doc, Set<String> entityClasses) {
        if (targetFile.exists()) {
            Set<String> alreadyDefined = PersistenceXmlHelper.getClassesAlreadyDefined(doc);
            if (!alreadyDefined.containsAll(entityClasses)) {
                TreeSet<String> undefined = new TreeSet<String>();
                for (String className : entityClasses) {
                    if (alreadyDefined.contains(className)) continue;
                    undefined.add(className);
                }
                this.getLog().warn((CharSequence)("The following classes was not defined in " + targetFile + " even " + "though they are available on the class path: " + Arrays.toString(undefined.toArray())));
            }
            entityClasses.removeAll(alreadyDefined);
        }
    }

    private int getLogLevel() {
        return AbstractSessionLog.translateStringToLoggingLevel((String)this.logLevel);
    }

    public void setLogLevel(String logLevel) {
        Level.parse(logLevel);
        this.logLevel = logLevel.toUpperCase();
    }

    private File[] getClassPathFiles() {
        List classpathElements;
        ArrayList<File> files = new ArrayList<File>();
        try {
            classpathElements = this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        for (Object o : classpathElements) {
            File file;
            if (o == null || !(file = new File(o.toString())).canRead()) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    private URL[] getClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (File file : this.getClassPathFiles()) {
                urls.add(file.toURI().toURL());
            }
            return urls.toArray(new URL[urls.size()]);
        }
        catch (MalformedURLException exc) {
            throw new RuntimeException(exc.getMessage(), exc);
        }
    }

    private Set<String> findEntities(ScanResult scanResult) {
        return new TreeSet<String>(scanResult.getNamesOfClassesWithAnnotationsAnyOf(new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class, Converter.class}));
    }

    private String[] getBasePackages() throws MojoFailureException {
        ArrayList<String> allBasePackages = new ArrayList<String>();
        if (this.basePackage != null && this.basePackages != null) {
            throw new MojoFailureException("<basePackage> and <basePackages> are mutually exclusive");
        }
        if (this.basePackage != null) {
            allBasePackages.add(this.basePackage);
        } else if (this.basePackages != null) {
            if (this.basePackages.length == 0) {
                throw new MojoFailureException("No <basePackage> elements specified within <basePackages>");
            }
            allBasePackages.addAll(Arrays.asList(this.basePackages));
        }
        return StringUtils.toStringArray(allBasePackages);
    }
}

