Opensearch Data Access & Management SDK for Java
================================================

Opensearch restful API version v3

Overview
--------
This SDK contains wrapper code used to call the Opensearch Cloud restful API from Java applications.


Prerequisites
-------------


Including the SDK in your project
---------------------------------

The easiest way to incorporate the SDK into your Java project is to use Maven. If you're using Maven already, simply add a new dependency to your `pom.xml`:

```xml
<dependency>
     <groupId>com.aliyun.opensearch</groupId>
      <artifactId>aliyun-sdk-opensearch</artifactId>
      <version>{lastest-sdk-version}</version>
</dependency>
```

Changes in version 3.2.0 (date: 2018-06-01)
------------------------

* NEW: 算法之下拉提示


Changes in version 3.1.7 (date: 2018-05-31)
------------------------

* NEW: 支持新计费模型 Quota


Changes in version 3.1.5 (date: 2017-12-21)
------------------------

* NEW: 根据应用名或 id 获取或更新 Quota


Changes in version 3.1.4 (date: 2017-06-23)
------------------------
* NEW: scroll支持sort.
* NEW: AppClient支持switchTo切换版本, 用于批量切换版本.
* NEW: 多应用搜索
* BUGFIX: 在使用完request后,将其关闭. 因为如果response是gzip流,若不关闭,连接不会归还到连接池.会导致连接池满,整个sdk hang住.



Changes in version 3.1.3 (date: 2016-12-21)
------------------------
* 将第三方抵赖放入opensearch的包中. 为了减小与用户的依赖冲突, 除了slf4j-api组件, 其他依赖全部relocated到opensearch的package下.
* FULLJSON支持
* commit时无论成功还是失败,都清掉buff里的doc.减少上sdk api使用上的歧义.
* suggest(下拉提示)功能确认相关组件已上线, sdk的功能已可开放使用.




Changes in version 3.1.2 (date:2016-10-14)
------------------------
* 提供DeepPageingIterator, 简化用户在深度翻页的编程.
* 缩短检查http连接池过期的间隔, 尽可能主动在本地关闭连接池中不可用的连接,以此确保连接池中连接都可用.
* 去掉对apache commons-codec包的依赖.避免用户的依赖或间接依赖,或运行时环境(tomcat容器)等产生此包的版本冲突.(codec相同的api不同的版本并不兼容.)
* 加入搜索的debug接口SearchResultDebug, 提供查询url和request,response的http header信息,便于调试.
* 修改了nonce,避免高QPS查询的情况下出现nonce重复.

Changes in version 3.1.1 (date:2016-09-28)
------------------------
* 按照集团编码规范修改相关接口的命名方式.

Changes in version 3.1.0 (date:2016-09-26)
------------------------
* 基于thrift协议框架的新版java sdk.
* 提供更友好的增量和查询接口,以及异常反馈.
* 支持对app的操作:创建(create), 查找(findById,findAll), 重建索引(reindex). 目前不支持delete, update, fork.
* 支持multi-partition查询的route value接口.
* 包含3.0分支的所有bugfix.



Changes in version 3.0.7
------------------------
* 计算签名时不将reuqest path转为小写, 意味着签名时appname是大小写敏感的.
* 加入multi-partition搜索支持: route value参数设置.
(see issue: https://aone.alibaba-inc.com/req/8789387)


Changes in version 3.0.6
------------------------
在V2版本SDK 有一个已知bug search(opts)，如果用户指定了first_formula_name 的时候，但是setFormulaName 而不是setFirstFormulaName。
在V3版本API不支持formula_name 和first_formula_name ,支持的是first_rank_name和second_rank_name
see issue: https://aone.alibaba-inc.com/issue/8724530


Changes in version 3.0.5
------------------------
重新开放push以json字符串为内容的api, 兼容v2的使用方式.


Changes in version 3.0.4
-----------------------
Nonce 值不正确. v2中的nonce是秒数的md5+秒数,在一秒内,相同的nonce只能用一次. 现在改成毫秒数+5位随机数.

Changes in version 3.0.3
-----------------------
Encode " " (blank) according to RFC 1738

Changes in version 3.0.2
-----------------------
* add parent to pom.
* force set default api version to v3, no need to specify via 'opts'

Changes in version 3.0.1
-----------------------
线上只支持大写的cmd: ADD, UPDATE, DELETE. 所以cmd全部改为大写. 暂不支持小写.

Changes in version 3.0.0
-----------------------
支持restful v3 API的SDK 首次发布

