/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SessionRecordSetIterator
implements Iterator<Record> {
    private TunnelRecordReader reader;
    private int cursor = 0;
    private List<Record> buffer;

    public SessionRecordSetIterator(TunnelRecordReader reader) {
        this.reader = reader;
    }

    public SessionRecordSetIterator(List<Record> buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null && this.buffer == null) {
            return false;
        }
        if (this.buffer == null) {
            this.fillBuffer();
        }
        return this.cursor < this.buffer.size();
    }

    @Override
    public Record next() {
        if (this.reader == null && this.buffer == null) {
            return null;
        }
        if (this.buffer == null) {
            this.fillBuffer();
        }
        return this.buffer.get(this.cursor++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private void fillBuffer() {
        this.buffer = new ArrayList<Record>();
        Record r = null;
        try {
            while ((r = this.reader.read()) != null) {
                this.buffer.add(r);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Read result failed:" + e.getMessage(), e);
        }
    }
}

