/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.security;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.StringUtils;
import java.util.HashMap;

public class SecurityConfiguration
extends LazyLoad {
    private SecurityConfigurationModel model = null;
    private String project;
    private RestClient client;
    private boolean strip;

    SecurityConfiguration(String project, RestClient client) {
        this(project, client, false);
    }

    SecurityConfiguration(String project, RestClient client, boolean strip) {
        this.project = project;
        this.client = client;
        this.strip = strip;
        this.lazyLoad();
    }

    @Override
    public void reload() throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project);
        HashMap<String, String> params = new HashMap<String, String>();
        if (!this.strip) {
            params.put("security_configuration", null);
        } else {
            params.put("security_configuration_without_exception_policy", null);
        }
        this.model = this.client.request(SecurityConfigurationModel.class, resource.toString(), "GET", params, null, null);
        this.setLoaded(true);
    }

    void update(String supervisionToken) throws OdpsException {
        try {
            StringBuilder resource = new StringBuilder();
            resource.append("/projects/").append(this.project);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("security_configuration", null);
            String xmlSecurityConfiguration = SimpleXmlUtils.marshal(this.model);
            HashMap<String, String> headers = null;
            if (supervisionToken != null) {
                headers = new HashMap<String, String>();
                headers.put("odps-x-supervision-token", supervisionToken);
            }
            this.client.stringRequest(resource.toString(), "PUT", params, headers, xmlSecurityConfiguration);
        }
        catch (OdpsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public boolean checkPermissionUsingAcl() {
        return this.model.checkPermissionUsingAcl;
    }

    public void enableCheckPermissionUsingAcl() {
        this.model.checkPermissionUsingAcl = true;
    }

    public void disableCheckPermissionUsingAcl() {
        this.model.checkPermissionUsingAcl = false;
    }

    public boolean checkPermissionUsingPolicy() {
        return this.model.checkPermissionUsingPolicy;
    }

    public void enableCheckPermissionUsingPolicy() {
        this.model.checkPermissionUsingPolicy = true;
    }

    public void disableCheckPermissionUsingPolicy() {
        this.model.checkPermissionUsingPolicy = false;
    }

    public boolean labelSecurity() {
        return this.model.labelSecurity;
    }

    public void enableLabelSecurity() {
        this.model.labelSecurity = true;
    }

    public void disableLabelSecurity() {
        this.model.labelSecurity = false;
    }

    public boolean objectCreatorHasAccessPermission() {
        return this.model.objectCreatorHasAccessPermission;
    }

    public void enableObjectCreatorHasAccessPermission() {
        this.model.objectCreatorHasAccessPermission = true;
    }

    public void disableObjectCreatorHasAccessPermission() {
        this.model.objectCreatorHasAccessPermission = false;
    }

    public boolean objectCreatorHasGrantPermission() {
        return this.model.objectCreatorHasGrantPermission;
    }

    public void enableObjectCreatorHasGrantPermission() {
        this.model.objectCreatorHasGrantPermission = true;
    }

    public void disableObjectCreatorHasGrantPermission() {
        this.model.objectCreatorHasGrantPermission = false;
    }

    public boolean projectProtection() {
        return this.model.projectProtection.protectedFlag.equals("true");
    }

    public void enableProjectProtection() {
        this.model.projectProtection.protectedFlag = "true";
        this.model.projectProtection.exceptionPolicy = null;
    }

    public void enableProjectProtection(String exceptionPolicy) {
        this.model.projectProtection.protectedFlag = "true";
        this.model.projectProtection.exceptionPolicy = exceptionPolicy;
    }

    public void disableProjectProtection() {
        this.model.projectProtection.protectedFlag = "false";
        this.model.projectProtection.exceptionPolicy = null;
    }

    public String getProjectProtectionExceptionPolicy() throws OdpsException {
        if (!this.projectProtection() || StringUtils.isNullOrEmpty((String)this.model.projectProtection.exceptionPolicy)) {
            throw new NoSuchObjectException("Exception Policy dose not exist!");
        }
        return this.model.projectProtection.exceptionPolicy;
    }

    public boolean checkPermissionUsingAclV2() {
        return this.model.checkPermissionUsingAclV2;
    }

    public boolean checkPermissionUsingPackageV2() {
        return this.model.checkPermissionUsingPackageV2;
    }

    public boolean supportAcl() {
        return this.model.supportAcl;
    }

    public boolean supportPolicy() {
        return this.model.supportPolicy;
    }

    public boolean supportPackage() {
        return this.model.supportPackage;
    }

    public boolean supportAclV2() {
        return this.model.supportAclV2;
    }

    public boolean supportPackageV2() {
        return this.model.supportPackageV2;
    }

    public boolean checkPermissionUsingPackage() {
        return this.model.checkPermissionUsingPackage;
    }

    public boolean createPackage() {
        return this.model.createPackage;
    }

    public boolean createPackageV2() {
        return this.model.createPackageV2;
    }

    public String getAuthorizationVersion() {
        return this.model.authorizationVersion;
    }

    public boolean checkDownloadPrivilege() {
        return this.model.downloadPrivilege;
    }

    public void enableDownloadPrivilege() {
        this.model.downloadPrivilege = true;
    }

    public void disableDownloadPrivilege() {
        this.model.downloadPrivilege = false;
    }

    @Root(name="SecurityConfiguration", strict=false)
    static class SecurityConfigurationModel {
        @Element(name="CheckPermissionUsingAcl", required=false)
        boolean checkPermissionUsingAcl;
        @Element(name="CheckPermissionUsingPolicy", required=false)
        boolean checkPermissionUsingPolicy;
        @Element(name="LabelSecurity", required=false)
        boolean labelSecurity;
        @Element(name="ObjectCreatorHasAccessPermission", required=false)
        boolean objectCreatorHasAccessPermission;
        @Element(name="ObjectCreatorHasGrantPermission", required=false)
        boolean objectCreatorHasGrantPermission;
        @Element(name="ProjectProtection", required=false)
        ProjectProtection projectProtection;
        @Element(name="CheckPermissionUsingAclV2", required=false)
        boolean checkPermissionUsingAclV2;
        @Element(name="CheckPermissionUsingPackageV2", required=false)
        boolean checkPermissionUsingPackageV2;
        @Element(name="SupportACL", required=false)
        boolean supportAcl;
        @Element(name="SupportPolicy", required=false)
        boolean supportPolicy;
        @Element(name="SupportPackage", required=false)
        boolean supportPackage;
        @Element(name="SupportACLV2", required=false)
        boolean supportAclV2;
        @Element(name="SupportPackageV2", required=false)
        boolean supportPackageV2;
        @Element(name="CheckPermissionUsingPackage", required=false)
        boolean checkPermissionUsingPackage;
        @Element(name="CreatePackage", required=false)
        boolean createPackage;
        @Element(name="CreatePackageV2", required=false)
        boolean createPackageV2;
        @Element(name="AuthorizationVersion", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String authorizationVersion;
        @Element(name="EnableDownloadPrivilege", required=false)
        boolean downloadPrivilege;

        SecurityConfigurationModel() {
        }

        @Root(name="ProjectProtection", strict=false)
        static class ProjectProtection {
            @Attribute(name="Protected", required=false)
            String protectedFlag;
            @Element(name="Exceptions", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String exceptionPolicy;

            ProjectProtection() {
            }
        }
    }
}

