/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Functions;
import com.aliyun.odps.Instances;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Projects;
import com.aliyun.odps.Resources;
import com.aliyun.odps.Tables;
import com.aliyun.odps.Task;
import com.aliyun.odps.Volumes;
import com.aliyun.odps.XFlows;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AccountFormat;
import com.aliyun.odps.account.AppAccount;
import com.aliyun.odps.commons.transport.DefaultTransport;
import com.aliyun.odps.ml.OfflineModels;
import com.aliyun.odps.rest.RestClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class Odps {
    private static final String defaultEndpoint = "http://service.odps.aliyun.com/api";
    private Account account;
    private AppAccount appAccount;
    private String endpoint;
    private String defaultProject;
    private Projects projects;
    private Tables tables;
    private Instances instances;
    private Resources resources;
    private Functions functions;
    private Volumes volumes;
    private XFlows xflows;
    private OfflineModels offlineModels;
    protected RestClient client;
    private String userAgent;
    private String logViewHost;
    private AccountFormat accountFormat = null;

    public void setAccount(Account account) {
        this.client.setAccount(account);
        this.account = account;
    }

    public void setAppAccount(AppAccount appAccount) {
        this.client.setAppAccount(appAccount);
        this.appAccount = appAccount;
    }

    public Odps(Account account) {
        this(account, null);
    }

    public Odps(Account account, AppAccount appAccount) {
        this.account = account;
        this.appAccount = appAccount;
        this.client = new RestClient(new DefaultTransport());
        this.client.setAccount(account);
        this.client.setAppAccount(appAccount);
        this.setUserAgent("");
        this.setEndpoint(defaultEndpoint);
        this.projects = new Projects(this);
        this.tables = new Tables(this);
        this.instances = new Instances(this);
        this.resources = new Resources(this);
        this.functions = new Functions(this);
        this.volumes = new Volumes(this.client);
        this.xflows = new XFlows(this);
        this.offlineModels = new OfflineModels(this);
    }

    public Odps(Odps odps) {
        this(odps.account, odps.appAccount);
        this.setDefaultProject(odps.getDefaultProject());
        this.setUserAgent(odps.getUserAgent());
        this.setEndpoint(odps.getEndpoint());
        this.setLogViewHost(odps.getLogViewHost());
        this.client.setIgnoreCerts(odps.getRestClient().isIgnoreCerts());
        this.instances.setDefaultRunningCluster(odps.instances.getDefaultRunningCluster());
    }

    public Projects projects() {
        return this.projects;
    }

    public Tables tables() {
        return this.tables;
    }

    public Instances instances() {
        return this.instances;
    }

    public Resources resources() {
        return this.resources;
    }

    public Functions functions() {
        return this.functions;
    }

    public Volumes volumes() {
        return this.volumes;
    }

    public Account getAccount() {
        return this.account;
    }

    public AppAccount getAppAccount() {
        return this.appAccount;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        try {
            URI uri = new URI(endpoint);
            this.endpoint = uri.toString();
            this.client.setEndpoint(this.endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
        this.client.setDefaultProject(defaultProject);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.client.setUserAgent(userAgent);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public LogView logview() {
        return new LogView(this);
    }

    public XFlows xFlows() {
        return this.xflows;
    }

    public OfflineModels offlineModels() {
        return this.offlineModels;
    }

    public Odps clone() {
        return new Odps(this);
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public String getLogViewHost() {
        return this.logViewHost;
    }

    public void setLogViewHost(String host) {
        this.logViewHost = host;
    }

    public void setAccountFormat(AccountFormat format) {
        this.accountFormat = format;
    }

    public AccountFormat getAccountFormat() {
        return this.accountFormat;
    }

    public void setGlobalSettings(Map<String, String> settings) {
        Task.setGlobalSettings(settings);
    }

    public Map<String, String> getGlobalSettings() {
        return Task.getGlobalSettings();
    }
}

