/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.StreamRecordPack;
import com.aliyun.odps.tunnel.io.WritePackResult;
import com.aliyun.odps.tunnel.io.proto.XstreamPack;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class StreamWriter {
    private RestClient tunnelServiceClient;
    private String path;
    private MessageDigest messageDigest;
    private Map<String, String> params;
    private Map<String, String> headers;
    private WritePackResult lastPackResult;

    public StreamWriter(RestClient tunnelServiceClient, String path, HashMap<String, String> params, Map<String, String> headers) {
        this.tunnelServiceClient = tunnelServiceClient;
        this.path = path;
        this.params = params;
        this.headers = headers;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public WritePackResult write(StreamRecordPack recordPack) throws TunnelException, IOException {
        return this.write(null, recordPack, null);
    }

    public WritePackResult write(StreamRecordPack recordPack, byte[] meta) throws TunnelException, IOException {
        return this.write(null, recordPack, meta);
    }

    public WritePackResult write(PartitionSpec partitionSpec, StreamRecordPack recordPack) throws TunnelException, IOException {
        return this.write(partitionSpec, recordPack, null);
    }

    public WritePackResult write(PartitionSpec partitionSpec, StreamRecordPack recordPack, byte[] meta) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Encoding", "deflate");
        try {
            byte[] bytes = recordPack.getByteArray();
            if ((null == bytes || 0 == bytes.length) && null == meta) {
                throw new TunnelException("both record pack and meta are empty.");
            }
            XstreamPack.XStreamPack.Builder pack = XstreamPack.XStreamPack.newBuilder();
            pack.setPackData(ByteString.copyFrom((byte[])bytes));
            if (null != meta) {
                pack.setPackMeta(ByteString.copyFrom((byte[])meta));
            }
            bytes = pack.build().toByteArray();
            if (partitionSpec != null && partitionSpec.toString().length() > 0) {
                params.put("partition", partitionSpec.toString().replaceAll("'", ""));
            }
            params.put("recordcount", String.valueOf(recordPack.getRecordCount()));
            headers.put("Content-MD5", this.generatorMD5(bytes));
            Response resp = this.tunnelServiceClient.requestForRawResponse(this.path, "PUT", params, headers, new ByteArrayInputStream(bytes), bytes.length);
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(new ByteArrayInputStream(resp.getBody()));
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(resp.getBody());
            this.loadFromJson(in);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
        return this.lastPackResult;
    }

    private void loadFromJson(InputStream is) throws TunnelException {
        try {
            String json = IOUtils.readStreamAsString(is);
            JSONObject tree = JSON.parseObject((String)json);
            String node = tree.getString("PackId");
            if (node == null) {
                throw new TunnelException("get pack id fail");
            }
            this.lastPackResult = new WritePackResult(node);
        }
        catch (Exception e) {
            throw new TunnelException("Invalid json content.", e);
        }
    }

    private String generatorMD5(byte[] bytes) {
        byte[] digest = this.messageDigest.digest(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

