/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.commons.proto.XstreamPack;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.datahub.DatahubRecordPack;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

@Deprecated
public class StreamUploadWriter {
    private RestClient tunnelServiceClient;
    private String path;
    private MessageDigest messageDigest;
    private HashMap<String, String> params;
    private HashMap<String, String> headers;
    private TunnelTableSchema schema;

    public StreamUploadWriter(RestClient tunnelServiceClient, String path) throws TunnelException {
        this.path = path;
        this.tunnelServiceClient = tunnelServiceClient;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.headers = new HashMap();
        this.headers.put("Content-Length", "0");
        this.headers.put("x-odps-tunnel-stream-version", "1");
        this.params = new HashMap();
        this.initiate();
        this.headers.put("Content-Type", "application/octet-stream");
        this.headers.put("x-odps-tunnel-version", String.valueOf(4));
    }

    public StreamUploadWriter(RestClient tunnelServiceClient, String path, HashMap<String, String> params, HashMap<String, String> headers, TunnelTableSchema schema) {
        this.tunnelServiceClient = tunnelServiceClient;
        this.path = path;
        this.params = params;
        this.headers = headers;
        this.schema = schema;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void initiate() throws TunnelException {
        block13: {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("query", "meta");
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.path, "GET", param, this.headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block13;
                }
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (null != conn) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void loadFromJson(InputStream is) throws TunnelException {
        try {
            String json = IOUtils.toString((InputStream)is);
            JSONObject tree = JSONObject.parseObject((String)json);
            JSONObject node = tree.getJSONObject("Schema");
            if (null == node) {
                throw new TunnelException("Get table type failed");
            }
            this.schema = new TunnelTableSchema(node);
        }
        catch (Exception e) {
            throw new TunnelException("Invalid json content.", e);
        }
    }

    public void write(DatahubRecordPack recordPack) throws TunnelException, IOException {
        this.write(null, recordPack);
    }

    public void write(PartitionSpec partitionSpec, DatahubRecordPack recordPack) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Encoding", "deflate");
        try {
            byte[] bytes = recordPack.getByteArray();
            XstreamPack.XStreamPack.Builder pack = XstreamPack.XStreamPack.newBuilder();
            pack.setPackData(ByteString.copyFrom((byte[])bytes));
            bytes = pack.build().toByteArray();
            if (null != partitionSpec && partitionSpec.toString().length() > 0) {
                params.put("partition", partitionSpec.toString().replace("'", ""));
            }
            params.put("recordcount", String.valueOf(recordPack.getRecordCount()));
            params.put("mode", "streamupload");
            headers.put("Content-MD5", this.generateMD5(bytes));
            Response resp = this.tunnelServiceClient.requestForRawResponse(this.path, "PUT", params, headers, new ByteArrayInputStream(bytes), bytes.length);
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(new ByteArrayInputStream(resp.getBody()));
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public TunnelTableSchema getSchema() {
        return this.schema;
    }

    private String generateMD5(byte[] bytes) {
        byte[] digest = this.messageDigest.digest(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

