/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.security;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.utils.StringUtils;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class SecurityConfiguration
extends LazyLoad {
    private SecurityConfigurationModel model = null;
    private String project;
    private RestClient client;

    SecurityConfiguration(String project, RestClient client) {
        this.project = project;
        this.client = client;
        this.lazyLoad();
    }

    @Override
    public void reload() throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("security_configuration", null);
        this.model = this.client.request(SecurityConfigurationModel.class, resource.toString(), "GET", params, null, null);
        this.setLoaded(true);
    }

    void update(String supervisionToken) throws OdpsException {
        try {
            StringBuilder resource = new StringBuilder();
            resource.append("/projects/").append(this.project);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("security_configuration", null);
            String xmlSecurityConfiguration = JAXBUtils.marshal(this.model, SecurityConfigurationModel.class);
            HashMap<String, String> headers = null;
            if (supervisionToken != null) {
                headers = new HashMap<String, String>();
                headers.put("odps-x-supervision-token", supervisionToken);
            }
            this.client.stringRequest(resource.toString(), "PUT", params, headers, xmlSecurityConfiguration);
        }
        catch (OdpsException e) {
            throw e;
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public boolean checkPermissionUsingAcl() {
        return this.model.checkPermissionUsingAcl;
    }

    public void enableCheckPermissionUsingAcl() {
        this.model.checkPermissionUsingAcl = true;
    }

    public void disableCheckPermissionUsingAcl() {
        this.model.checkPermissionUsingAcl = false;
    }

    public boolean checkPermissionUsingPolicy() {
        return this.model.checkPermissionUsingPolicy;
    }

    public void enableCheckPermissionUsingPolicy() {
        this.model.checkPermissionUsingPolicy = true;
    }

    public void disableCheckPermissionUsingPolicy() {
        this.model.checkPermissionUsingPolicy = false;
    }

    public boolean labelSecurity() {
        return this.model.labelSecurity;
    }

    public void enableLabelSecurity() {
        this.model.labelSecurity = true;
    }

    public void disableLabelSecurity() {
        this.model.labelSecurity = false;
    }

    public boolean objectCreatorHasAccessPermission() {
        return this.model.objectCreatorHasAccessPermission;
    }

    public void enableObjectCreatorHasAccessPermission() {
        this.model.objectCreatorHasAccessPermission = true;
    }

    public void disableObjectCreatorHasAccessPermission() {
        this.model.objectCreatorHasAccessPermission = false;
    }

    public boolean objectCreatorHasGrantPermission() {
        return this.model.objectCreatorHasGrantPermission;
    }

    public void enableObjectCreatorHasGrantPermission() {
        this.model.objectCreatorHasGrantPermission = true;
    }

    public void disableObjectCreatorHasGrantPermission() {
        this.model.objectCreatorHasGrantPermission = false;
    }

    public boolean projectProtection() {
        return this.model.projectProtection.protectedFlag.equals("true");
    }

    public void enableProjectProtection() {
        this.model.projectProtection.protectedFlag = "true";
        this.model.projectProtection.exceptionPolicy = null;
    }

    public void enableProjectProtection(String exceptionPolicy) {
        this.model.projectProtection.protectedFlag = "true";
        this.model.projectProtection.exceptionPolicy = exceptionPolicy;
    }

    public void disableProjectProtection() {
        this.model.projectProtection.protectedFlag = "false";
        this.model.projectProtection.exceptionPolicy = null;
    }

    public String getProjectProtectionExceptionPolicy() throws OdpsException {
        if (!this.projectProtection() || StringUtils.isNullOrEmpty((String)this.model.projectProtection.exceptionPolicy)) {
            throw new NoSuchObjectException("Exception Policy dose not exist!");
        }
        return this.model.projectProtection.exceptionPolicy;
    }

    public boolean checkPermissionUsingAclV2() {
        return this.model.checkPermissionUsingAclV2;
    }

    public boolean checkPermissionUsingPackageV2() {
        return this.model.checkPermissionUsingPackageV2;
    }

    public boolean supportAcl() {
        return this.model.supportAcl;
    }

    public boolean supportPolicy() {
        return this.model.supportPolicy;
    }

    public boolean supportPackage() {
        return this.model.supportPackage;
    }

    public boolean supportAclV2() {
        return this.model.supportAclV2;
    }

    public boolean supportPackageV2() {
        return this.model.supportPackageV2;
    }

    public boolean checkPermissionUsingPackage() {
        return this.model.checkPermissionUsingPackage;
    }

    public boolean createPackage() {
        return this.model.createPackage;
    }

    public boolean createPackageV2() {
        return this.model.createPackageV2;
    }

    public String getAuthorizationVersion() {
        return this.model.authorizationVersion;
    }

    @XmlRootElement(name="SecurityConfiguration")
    static class SecurityConfigurationModel {
        @XmlElement(name="CheckPermissionUsingAcl")
        boolean checkPermissionUsingAcl;
        @XmlElement(name="CheckPermissionUsingPolicy")
        boolean checkPermissionUsingPolicy;
        @XmlElement(name="LabelSecurity")
        boolean labelSecurity;
        @XmlElement(name="ObjectCreatorHasAccessPermission")
        boolean objectCreatorHasAccessPermission;
        @XmlElement(name="ObjectCreatorHasGrantPermission")
        boolean objectCreatorHasGrantPermission;
        @XmlElement(name="ProjectProtection")
        ProjectProtection projectProtection;
        @XmlElement(name="CheckPermissionUsingAclV2")
        boolean checkPermissionUsingAclV2;
        @XmlElement(name="CheckPermissionUsingPackageV2")
        boolean checkPermissionUsingPackageV2;
        @XmlElement(name="SupportACL")
        boolean supportAcl;
        @XmlElement(name="SupportPolicy")
        boolean supportPolicy;
        @XmlElement(name="SupportPackage")
        boolean supportPackage;
        @XmlElement(name="SupportACLV2")
        boolean supportAclV2;
        @XmlElement(name="SupportPackageV2")
        boolean supportPackageV2;
        @XmlElement(name="CheckPermissionUsingPackage")
        boolean checkPermissionUsingPackage;
        @XmlElement(name="CreatePackage")
        boolean createPackage;
        @XmlElement(name="CreatePackageV2")
        boolean createPackageV2;
        @XmlElement(name="AuthorizationVersion")
        String authorizationVersion;

        SecurityConfigurationModel() {
        }

        @XmlRootElement(name="ProjectProtection")
        static class ProjectProtection {
            @XmlAttribute(name="Protected")
            String protectedFlag;
            @XmlElement(name="Exceptions")
            String exceptionPolicy;

            ProjectProtection() {
            }
        }
    }
}

