/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.datahub;

import com.aliyun.odps.data.Record;
import java.util.List;
import java.util.Map;

public class ReadPackResult {
    private String currPackId;
    private String nextPackId;
    private long timeStamp;
    private List<Record> records;
    private byte[] meta;
    private Map<String, String> kvMeta;
    private String partitionSpec;

    public ReadPackResult(String packId, String nextPackId, long timeStamp, String partitionSpec, List<Record> records) {
        this(packId, nextPackId, timeStamp, partitionSpec, records, null, null);
    }

    public ReadPackResult(String packId, String nextPackId, long timeStamp, String partitionSpec, List<Record> records, byte[] meta) {
        this(packId, nextPackId, timeStamp, partitionSpec, records, meta, null);
    }

    public ReadPackResult(String packId, String nextPackId, long timeStamp, String partitionSpec, List<Record> records, Map<String, String> kvMeta) {
        this(packId, nextPackId, timeStamp, partitionSpec, records, null, kvMeta);
    }

    private ReadPackResult(String packId, String nextPackId, long timeStamp, String partitionSpec, List<Record> records, byte[] meta, Map<String, String> kvMeta) {
        if (packId == null || nextPackId == null || packId.equals("") || nextPackId.equals("")) {
            throw new IllegalArgumentException("Invalid pack string.");
        }
        this.currPackId = packId;
        this.nextPackId = nextPackId;
        this.timeStamp = timeStamp;
        this.partitionSpec = partitionSpec;
        this.records = records;
        this.meta = meta;
        this.kvMeta = kvMeta;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getPackId() {
        return this.currPackId;
    }

    public String getNextPackId() {
        return this.nextPackId;
    }

    public byte[] getMeta() {
        return this.meta;
    }

    public Map<String, String> getKvMeta() {
        return this.kvMeta;
    }

    public String getPartitionSpec() {
        return this.partitionSpec;
    }
}

