/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.datahub;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamWriter;
import com.aliyun.odps.data.Record;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DatahubRecordPack {
    private ByteArrayOutputStream byteArrayOutputStream;
    private ProtobufRecordStreamWriter protobufRecordStreamWriter;
    private TableSchema recordSchema;
    private long recordCount;
    private int maxPackSize = 0x800000;
    private boolean packSealed = false;

    public DatahubRecordPack(TableSchema recordSchema) throws IOException {
        this.recordSchema = recordSchema;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.recordCount = 0L;
        this.protobufRecordStreamWriter = new ProtobufRecordStreamWriter(recordSchema, this.byteArrayOutputStream);
    }

    public void append(Record r) throws IOException {
        if (this.packSealed) {
            throw new IOException("Append record to a sealed pack. Please use Clear() to clear this pack or new another pack.");
        }
        if (this.protobufRecordStreamWriter == null) {
            this.protobufRecordStreamWriter = new ProtobufRecordStreamWriter(this.recordSchema, this.byteArrayOutputStream);
        }
        if (this.protobufRecordStreamWriter.getTotalBytes() >= (long)this.maxPackSize) {
            throw new IOException("Pack reach max size. Please send this pack and create new pack to append.");
        }
        this.protobufRecordStreamWriter.write(r);
        ++this.recordCount;
    }

    public void clear() {
        try {
            if (this.protobufRecordStreamWriter != null) {
                this.protobufRecordStreamWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.protobufRecordStreamWriter = null;
        this.byteArrayOutputStream.reset();
        this.recordCount = 0L;
        this.packSealed = false;
    }

    public byte[] getByteArray() throws IOException {
        this.packSealed = true;
        if (this.protobufRecordStreamWriter != null) {
            this.protobufRecordStreamWriter.close();
            this.protobufRecordStreamWriter = null;
        }
        return this.byteArrayOutputStream.toByteArray();
    }

    public long getRecordCount() {
        return this.recordCount;
    }
}

