/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.utils.StringUtils;
import java.util.HashMap;

public class LogView {
    private static final String POLICY_TYPE = "BEARER";
    private static final String HOST_DEFAULT = "http://logview.odps.aliyun.com";
    private String logViewHost = "";
    Odps odps;

    public LogView(Odps odps) {
        this.odps = odps;
    }

    private String getLogviewHost() {
        if (this.odps.getLogViewHost() != null) {
            return this.odps.getLogViewHost();
        }
        RestClient restClient = this.odps.clone().getRestClient();
        try {
            String resource = "/logview/host";
            HashMap<String, String> params = new HashMap<String, String>();
            Response resp = restClient.request(resource, "GET", params, null, null);
            String logViewHost = new String(resp.getBody());
            if (StringUtils.isNullOrEmpty((String)logViewHost)) {
                return HOST_DEFAULT;
            }
            return logViewHost;
        }
        catch (Exception e) {
            return HOST_DEFAULT;
        }
    }

    public String getLogViewHost() {
        if (StringUtils.isNullOrEmpty((String)this.logViewHost)) {
            this.logViewHost = this.getLogviewHost();
        }
        return this.logViewHost;
    }

    public void setLogViewHost(String logViewHost) {
        this.logViewHost = logViewHost;
    }

    public String generateLogView(Instance instance, long hours) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)this.logViewHost)) {
            this.logViewHost = this.getLogviewHost();
        }
        String token = this.generateInstanceToken(instance, hours);
        String logview = this.logViewHost + "/logview/?h=" + this.odps.getEndpoint() + "&p=" + instance.getProject() + "&i=" + instance.getId() + "&token=" + token;
        return logview;
    }

    public String generateInstanceToken(Instance instance, long hours) throws OdpsException {
        SecurityManager sm = this.odps.projects().get(instance.getProject()).getSecurityManager();
        return sm.generateAuthorizationToken(this.generatePolicy(instance, hours), POLICY_TYPE);
    }

    private String generatePolicy(Instance instance, long hours) {
        String policy = "{\n    \"expires_in_hours\": " + String.valueOf(hours) + ",\n    \"policy\": {\n        \"Statement\": [{\n            \"Action\": [\"odps:Read\"],\n            \"Effect\": \"Allow\",\n            \"Resource\": \"acs:odps:*:projects/" + instance.getProject() + "/instances/" + instance.getId() + "\"\n        }],\n        \"Version\": \"1\"\n    }\n}";
        return policy;
    }
}

