/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.rest;

public enum RestHttpMethod {
                            GET("GET"), POST("POST"), PUT("PUT"), DELETE("DELETE");

    private final String code;
    private final String description;

    RestHttpMethod(String code, String description) {
        this.code = code;
        this.description = description;
    }

    RestHttpMethod(String description) {
        this.code = name();
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public boolean hasPostBody() {
        return this == POST || this == PUT;
    }
}
