/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.product;

import cn.com.antcloud.api.common.BaseRequest;

public abstract class AntCloudProdRequest<T extends AntCloudProdResponse> extends BaseRequest<T> {
    private String productInstanceId;
    private String regionName;

    public AntCloudProdRequest(String method, String version) {
        this.setMethod(method);
        this.setVersion(version);
        this.setSdkVersion("UnSet-SDK-Version");
    }

    public AntCloudProdRequest(String method, String version, String productInstanceId) {
        this.setMethod(method);
        this.setVersion(version);
        this.productInstanceId = productInstanceId;
        this.setSdkVersion("UnSet-SDK-Version");
    }

    public AntCloudProdRequest(String method, String version, String sdkVersion,
                               String productInstanceId) {
        this.setMethod(method);
        this.setVersion(version);
        this.productInstanceId = productInstanceId;
        this.setSdkVersion(sdkVersion);
    }

    public String getProductInstanceId() {
        return productInstanceId;
    }

    public void setProductInstanceId(String productInstanceId) {
        this.productInstanceId = productInstanceId;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }
}
