/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.lang.reflect.Type;

public class GwJsons {

    private static final SerializeConfig config;

    static {
        config = new SerializeConfig();
        config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }

    public static String toString(Object o) {
        return JSON.toJSONString(o, config, SerializerFeature.DisableCircularReferenceDetect,
            SerializerFeature.UseISO8601DateFormat);
    }

    public static String toString(JSONObject o) {
        return JSON.toJSONString(o, SerializerFeature.DisableCircularReferenceDetect,
            SerializerFeature.UseISO8601DateFormat);
    }

    public static JSONObject toJSON(Object o) {
        return (JSONObject) JSON.toJSON(o, config);
    }

    public static <T> T parse(String s, Class<T> clazz) {
        return JSON.parseObject(s, clazz);
    }

    public static JSONObject parse(String s) {
        return JSON.parseObject(s);
    }

    public static <T> T parse(String s, Type type) {
        return JSON.parseObject(s, type);
    }

    public static <T> T parse(JSONObject jsonObject, Class<T> clazz) {
        return JSON.parseObject(jsonObject.toJSONString(), clazz);
    }

    public static <T> T parse(JSONObject jsonObject, Type type) {
        return JSON.parseObject(jsonObject.toJSONString(), type);
    }

}
