/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.antcloud;

import cn.com.antcloud.api.common.BaseRequest;

public abstract class AntCloudRequest<T extends AntCloudResponse> extends BaseRequest<T> {

    private String customer;
    private String tenant;
    private String workspace;

    protected AntCloudRequest(String method, String version) {
        this.setMethod(method);
        this.setVersion(version);
        this.setSdkVersion("UnSet-SDK-Version");
    }

    protected AntCloudRequest(String method, String version, String sdkVersion) {
        this.setMethod(method);
        this.setVersion(version);
        this.setSdkVersion(sdkVersion);
    }

    public String getCustomer() {
        return customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public String getTenant() {
        return tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getWorkspace() {
        return workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

}
