//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.response;

import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.Long;
import java.lang.String;

/**
 * 链上核验 */
public class VerifyBlockchainResponse extends AntCloudProdResponse {
  private String txHash;

  private String status;

  private String blockHash;

  private Long blockHeight;

  private String dataType;

  private String timestamp;

  /**
   * 统一证据编号（存证交易HASH） */
  public String getTxHash() {
    return this.txHash;
  }

  /**
   * 统一证据编号（存证交易HASH） */
  public void setTxHash(String txHash) {
    this.txHash = txHash;
  }

  /**
   * 核验结果 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 核验结果 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 所在区块hash */
  public String getBlockHash() {
    return this.blockHash;
  }

  /**
   * 所在区块hash */
  public void setBlockHash(String blockHash) {
    this.blockHash = blockHash;
  }

  /**
   * 区块链高度 */
  public Long getBlockHeight() {
    return this.blockHeight;
  }

  /**
   * 区块链高度 */
  public void setBlockHeight(Long blockHeight) {
    this.blockHeight = blockHeight;
  }

  /**
   * 存证类型 */
  public String getDataType() {
    return this.dataType;
  }

  /**
   * 存证类型 */
  public void setDataType(String dataType) {
    this.dataType = dataType;
  }

  /**
   * 存证时间 */
  public String getTimestamp() {
    return this.timestamp;
  }

  /**
   * 存证时间 */
  public void setTimestamp(String timestamp) {
    this.timestamp = timestamp;
  }
}
