//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.response.QueryUserListResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 查询用户信息列表 */
public class QueryUserListRequest extends AntCloudProdRequest<QueryUserListResponse> {
  @NotNull
  @Min(1)
  private Long pageIndex;

  @NotNull
  @Min(1)
  @Max(100)
  private Long pageSize;

  private String status;

  public QueryUserListRequest(String productInstanceId) {
    super("blockchain.bccr.user.list.query", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public QueryUserListRequest() {
    super("blockchain.bccr.user.list.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 页码，从1开始 */
  public Long getPageIndex() {
    return this.pageIndex;
  }

  /**
   * 页码，从1开始 */
  public void setPageIndex(Long pageIndex) {
    this.pageIndex = pageIndex;
  }

  /**
   * 每页数据，1~100 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页数据，1~100 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 用户状态 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 用户状态 */
  public void setStatus(String status) {
    this.status = status;
  }
}
