//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.model.MonitorType;
import cn.com.antcloud.api.bccr.v1_0_0.response.ListMonitorProviderResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 获取传播监测能力服务商列表 */
public class ListMonitorProviderRequest extends AntCloudProdRequest<ListMonitorProviderResponse> {
  @NotNull
  private List<MonitorType> monitorTypes;

  public ListMonitorProviderRequest(String productInstanceId) {
    super("blockchain.bccr.monitor.provider.list", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public ListMonitorProviderRequest() {
    super("blockchain.bccr.monitor.provider.list", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 需监测文件类型 */
  public List<MonitorType> getMonitorTypes() {
    return this.monitorTypes;
  }

  /**
   * 需监测文件类型 */
  public void setMonitorTypes(List<MonitorType> monitorTypes) {
    this.monitorTypes = monitorTypes;
  }
}
