//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.response.GetCertificateResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 版权平台获取版权登记证书 */
public class GetCertificateRequest extends AntCloudProdRequest<GetCertificateResponse> {
  @NotNull
  private String certificateType;

  @NotNull
  private String featuresType;

  @NotNull
  private String registerId;

  public GetCertificateRequest(String productInstanceId) {
    super("blockchain.bccr.certificate.get", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public GetCertificateRequest() {
    super("blockchain.bccr.certificate.get", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 证书类型 */
  public String getCertificateType() {
    return this.certificateType;
  }

  /**
   * 证书类型 */
  public void setCertificateType(String certificateType) {
    this.certificateType = certificateType;
  }

  /**
   * 功能类型 */
  public String getFeaturesType() {
    return this.featuresType;
  }

  /**
   * 功能类型 */
  public void setFeaturesType(String featuresType) {
    this.featuresType = featuresType;
  }

  /**
   * 版权登记id */
  public String getRegisterId() {
    return this.registerId;
  }

  /**
   * 版权登记id */
  public void setRegisterId(String registerId) {
    this.registerId = registerId;
  }
}
