//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.model.ProxyData;
import cn.com.antcloud.api.bccr.v1_0_0.response.CreateScreenshotResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 创建网页取证 */
public class CreateScreenshotRequest extends AntCloudProdRequest<CreateScreenshotResponse> {
  @NotNull
  private String name;

  private String memo;

  @NotNull
  private String url;

  private String orgId;

  @NotNull
  private String certName;

  @NotNull
  private String certNo;

  @NotNull
  private String certType;

  private String legalPersonName;

  private String legalPersonNo;

  private String agentName;

  private String agentNo;

  private String phoneNum;

  private ProxyData proxyInfo;

  @NotNull
  private String clientToken;

  public CreateScreenshotRequest(String productInstanceId) {
    super("blockchain.bccr.screenshot.create", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public CreateScreenshotRequest() {
    super("blockchain.bccr.screenshot.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 取证名称（最长128个字符） */
  public String getName() {
    return this.name;
  }

  /**
   * 取证名称（最长128个字符） */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 取证备注（最长512个字符） */
  public String getMemo() {
    return this.memo;
  }

  /**
   * 取证备注（最长512个字符） */
  public void setMemo(String memo) {
    this.memo = memo;
  }

  /**
   * 取证地址（最长2048个字符） */
  public String getUrl() {
    return this.url;
  }

  /**
   * 取证地址（最长2048个字符） */
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * 公证处Id */
  public String getOrgId() {
    return this.orgId;
  }

  /**
   * 公证处Id */
  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }

  /**
   * 取证人证件名称 */
  public String getCertName() {
    return this.certName;
  }

  /**
   * 取证人证件名称 */
  public void setCertName(String certName) {
    this.certName = certName;
  }

  /**
   * 取证人证件号码 */
  public String getCertNo() {
    return this.certNo;
  }

  /**
   * 取证人证件号码 */
  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  /**
   * 取证人证件类型 */
  public String getCertType() {
    return this.certType;
  }

  /**
   * 取证人证件类型 */
  public void setCertType(String certType) {
    this.certType = certType;
  }

  /**
   * 法人代表姓名(如果certType为BUSINESS_LICENSE 则必传) */
  public String getLegalPersonName() {
    return this.legalPersonName;
  }

  /**
   * 法人代表姓名(如果certType为BUSINESS_LICENSE 则必传) */
  public void setLegalPersonName(String legalPersonName) {
    this.legalPersonName = legalPersonName;
  }

  /**
   * 法人代表身份证号(如果certType为BUSINESS_LICENSE 则必传) */
  public String getLegalPersonNo() {
    return this.legalPersonNo;
  }

  /**
   * 法人代表身份证号(如果certType为BUSINESS_LICENSE 则必传) */
  public void setLegalPersonNo(String legalPersonNo) {
    this.legalPersonNo = legalPersonNo;
  }

  /**
   * 企业用户取证人姓名(如果certType为BUSINESS_LICENSE 则必传) */
  public String getAgentName() {
    return this.agentName;
  }

  /**
   * 企业用户取证人姓名(如果certType为BUSINESS_LICENSE 则必传) */
  public void setAgentName(String agentName) {
    this.agentName = agentName;
  }

  /**
   * 企业用户取证人身份证号(如果certType为BUSINESS_LICENSE 则必传) */
  public String getAgentNo() {
    return this.agentNo;
  }

  /**
   * 企业用户取证人身份证号(如果certType为BUSINESS_LICENSE 则必传) */
  public void setAgentNo(String agentNo) {
    this.agentNo = agentNo;
  }

  /**
   * 取证人电话号码，生成公证处证书需要，公证处需要作登记 格式范例：(86-573)2651630   或  (86)13738258505 */
  public String getPhoneNum() {
    return this.phoneNum;
  }

  /**
   * 取证人电话号码，生成公证处证书需要，公证处需要作登记 格式范例：(86-573)2651630   或  (86)13738258505 */
  public void setPhoneNum(String phoneNum) {
    this.phoneNum = phoneNum;
  }

  /**
   * 代理信息 */
  public ProxyData getProxyInfo() {
    return this.proxyInfo;
  }

  /**
   * 代理信息 */
  public void setProxyInfo(ProxyData proxyInfo) {
    this.proxyInfo = proxyInfo;
  }

  /**
   * 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符 */
  public String getClientToken() {
    return this.clientToken;
  }

  /**
   * 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符 */
  public void setClientToken(String clientToken) {
    this.clientToken = clientToken;
  }
}
