//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.model.ProxyData;
import cn.com.antcloud.api.bccr.v1_0_0.response.CreateRecodescreenResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 创建录屏取证(废弃) */
public class CreateRecodescreenRequest extends AntCloudProdRequest<CreateRecodescreenResponse> {
  @NotNull
  private String name;

  private String memo;

  private List<String> url;

  @NotNull
  private String type;

  @NotNull
  private String area;

  private String screenCode;

  @NotNull
  private Long maxTimeInMin;

  private Long waitInMin;

  private String crossRegion;

  private String ipType;

  private String callbackUrl;

  private String orgId;

  @NotNull
  private String certName;

  @NotNull
  private String certNo;

  @NotNull
  private String certType;

  private String legalPersonName;

  private String legalPersonNo;

  private String agent;

  private String agentNo;

  private String phoneNum;

  private ProxyData proxyInfo;

  @NotNull
  private String clientToken;

  public CreateRecodescreenRequest(String productInstanceId) {
    super("blockchain.bccr.recodescreen.create", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public CreateRecodescreenRequest() {
    super("blockchain.bccr.recodescreen.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 取证名称（最长128个字符） */
  public String getName() {
    return this.name;
  }

  /**
   * 取证名称（最长128个字符） */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 取证备注（最长512个字符） */
  public String getMemo() {
    return this.memo;
  }

  /**
   * 取证备注（最长512个字符） */
  public void setMemo(String memo) {
    this.memo = memo;
  }

  /**
   * 预校验网址和预打开网页（不能大于10条） */
  public List<String> getUrl() {
    return this.url;
  }

  /**
   * 预校验网址和预打开网页（不能大于10条） */
  public void setUrl(List<String> url) {
    this.url = url;
  }

  /**
   * 取证类型 具体见附录 RecordScreenType */
  public String getType() {
    return this.type;
  }

  /**
   * 取证类型 具体见附录 RecordScreenType */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * 取证服务器地域 具体见附录 RecordScreenArea */
  public String getArea() {
    return this.area;
  }

  /**
   * 取证服务器地域 具体见附录 RecordScreenArea */
  public void setArea(String area) {
    this.area = area;
  }

  /**
   * 定制录屏桌面识别码，目前取值只有默认值：DEFAULT */
  public String getScreenCode() {
    return this.screenCode;
  }

  /**
   * 定制录屏桌面识别码，目前取值只有默认值：DEFAULT */
  public void setScreenCode(String screenCode) {
    this.screenCode = screenCode;
  }

  /**
   * 最大录屏时间，maxTimeInMin不能小于6min，不能大于300min */
  public Long getMaxTimeInMin() {
    return this.maxTimeInMin;
  }

  /**
   * 最大录屏时间，maxTimeInMin不能小于6min，不能大于300min */
  public void setMaxTimeInMin(Long maxTimeInMin) {
    this.maxTimeInMin = maxTimeInMin;
  }

  /**
   * 服务器进入ready状态，指定时间未开始进入abort状态的等待时间，单位为分钟，默认1min，waitInMin不能小于1，不能大于10min */
  public Long getWaitInMin() {
    return this.waitInMin;
  }

  /**
   * 服务器进入ready状态，指定时间未开始进入abort状态的等待时间，单位为分钟，默认1min，waitInMin不能小于1，不能大于10min */
  public void setWaitInMin(Long waitInMin) {
    this.waitInMin = waitInMin;
  }

  /**
   * 当所选地域无机器资源时，是否使用其它地域
   *
   * 目前取值只有默认值：FORBID */
  public String getCrossRegion() {
    return this.crossRegion;
  }

  /**
   * 当所选地域无机器资源时，是否使用其它地域
   *
   * 目前取值只有默认值：FORBID */
  public void setCrossRegion(String crossRegion) {
    this.crossRegion = crossRegion;
  }

  /**
   * ip地域取值
   *
   * 目前取值只有默认值：ANY */
  public String getIpType() {
    return this.ipType;
  }

  /**
   * ip地域取值
   *
   * 目前取值只有默认值：ANY */
  public void setIpType(String ipType) {
    this.ipType = ipType;
  }

  /**
   * 回调地址 */
  public String getCallbackUrl() {
    return this.callbackUrl;
  }

  /**
   * 回调地址 */
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  /**
   * 公证处Id */
  public String getOrgId() {
    return this.orgId;
  }

  /**
   * 公证处Id */
  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }

  /**
   * 取证人证件名称 */
  public String getCertName() {
    return this.certName;
  }

  /**
   * 取证人证件名称 */
  public void setCertName(String certName) {
    this.certName = certName;
  }

  /**
   * 	
   * 取证人证件号码 */
  public String getCertNo() {
    return this.certNo;
  }

  /**
   * 	
   * 取证人证件号码 */
  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  /**
   * 取证人证件类型 具体见附录CertType */
  public String getCertType() {
    return this.certType;
  }

  /**
   * 取证人证件类型 具体见附录CertType */
  public void setCertType(String certType) {
    this.certType = certType;
  }

  /**
   * 企业法人代表姓名(如果certType为BUSINESS_LICENSE 则必传) */
  public String getLegalPersonName() {
    return this.legalPersonName;
  }

  /**
   * 企业法人代表姓名(如果certType为BUSINESS_LICENSE 则必传) */
  public void setLegalPersonName(String legalPersonName) {
    this.legalPersonName = legalPersonName;
  }

  /**
   * 企业法人代表身份证号(如果certType为BUSINESS_LICENSE 则必传) */
  public String getLegalPersonNo() {
    return this.legalPersonNo;
  }

  /**
   * 企业法人代表身份证号(如果certType为BUSINESS_LICENSE 则必传) */
  public void setLegalPersonNo(String legalPersonNo) {
    this.legalPersonNo = legalPersonNo;
  }

  /**
   * 企业用户取证人姓名(如果certType为BUSINESS_LICENSE 则必传) */
  public String getAgent() {
    return this.agent;
  }

  /**
   * 企业用户取证人姓名(如果certType为BUSINESS_LICENSE 则必传) */
  public void setAgent(String agent) {
    this.agent = agent;
  }

  /**
   * 企业用户取证人身份证号(如果certType为BUSINESS_LICENSE 则必传) */
  public String getAgentNo() {
    return this.agentNo;
  }

  /**
   * 企业用户取证人身份证号(如果certType为BUSINESS_LICENSE 则必传) */
  public void setAgentNo(String agentNo) {
    this.agentNo = agentNo;
  }

  /**
   * 取证人电话号码，生成公证处证书需要，公证处需要作登记 格式范例：(86-573)2651630   或  (86)13738258505 */
  public String getPhoneNum() {
    return this.phoneNum;
  }

  /**
   * 取证人电话号码，生成公证处证书需要，公证处需要作登记 格式范例：(86-573)2651630   或  (86)13738258505 */
  public void setPhoneNum(String phoneNum) {
    this.phoneNum = phoneNum;
  }

  /**
   * 代理信息 */
  public ProxyData getProxyInfo() {
    return this.proxyInfo;
  }

  /**
   * 代理信息 */
  public void setProxyInfo(ProxyData proxyInfo) {
    this.proxyInfo = proxyInfo;
  }

  /**
   * 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。更多详情，请参见如何保证幂等性。 */
  public String getClientToken() {
    return this.clientToken;
  }

  /**
   * 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。更多详情，请参见如何保证幂等性。 */
  public void setClientToken(String clientToken) {
    this.clientToken = clientToken;
  }
}
